/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.utils.SystemUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemotingServer {
    private static final Logger log = LoggerFactory.getLogger(AbstractRemotingServer.class);
    private static final int DEFAULT_SLEEP_SECONDS = 30;
    private EventLoopGroup bossGroup;
    private EventLoopGroup ioGroup;
    private EventExecutorGroup workerGroup;
    private int port;
    private static final int MAX_THREADS = Runtime.getRuntime().availableProcessors();

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public EventLoopGroup getIoGroup() {
        return this.ioGroup;
    }

    public EventExecutorGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public int getPort() {
        return this.port;
    }

    public void setBossGroup(EventLoopGroup bossGroup) {
        this.bossGroup = bossGroup;
    }

    public void setIoGroup(EventLoopGroup ioGroup) {
        this.ioGroup = ioGroup;
    }

    public void setWorkerGroup(EventExecutorGroup workerGroup) {
        this.workerGroup = workerGroup;
    }

    public void setPort(int port) {
        this.port = port;
    }

    private void buildBossGroup(String threadPrefix) {
        this.bossGroup = this.useEpoll() ? new EpollEventLoopGroup(1, (ThreadFactory)new EventMeshThreadFactory(threadPrefix + "NettyEpoll-Boss", true)) : new NioEventLoopGroup(1, (ThreadFactory)new EventMeshThreadFactory(threadPrefix + "NettyNio-Boss", true));
    }

    private void buildIOGroup(String threadPrefix) {
        this.ioGroup = this.useEpoll() ? new EpollEventLoopGroup(MAX_THREADS, (ThreadFactory)new EventMeshThreadFactory(threadPrefix + "-NettyEpoll-IO")) : new NioEventLoopGroup(MAX_THREADS, (ThreadFactory)new EventMeshThreadFactory(threadPrefix + "-NettyNio-IO"));
    }

    private void buildWorkerGroup(String threadPrefix) {
        this.workerGroup = new NioEventLoopGroup(MAX_THREADS, (ThreadFactory)new EventMeshThreadFactory(threadPrefix + "-worker"));
    }

    public void init(String threadPrefix) throws Exception {
        this.buildBossGroup(threadPrefix);
        this.buildIOGroup(threadPrefix);
        this.buildWorkerGroup(threadPrefix);
    }

    public void shutdown() throws Exception {
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            if (log.isInfoEnabled()) {
                log.info("shutdown bossGroup");
            }
        }
        ThreadUtils.randomPause((long)TimeUnit.SECONDS.toMillis(30L));
        if (this.ioGroup != null) {
            this.ioGroup.shutdownGracefully();
            if (log.isInfoEnabled()) {
                log.info("shutdown ioGroup");
            }
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            if (log.isInfoEnabled()) {
                log.info("shutdown workerGroup");
            }
        }
    }

    protected boolean useEpoll() {
        return SystemUtils.isLinuxPlatform() && Epoll.isAvailable();
    }

    public abstract void start() throws Exception;
}

