/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.admin;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.webhook.admin.FileWebHookConfigOperation;
import org.apache.eventmesh.webhook.admin.NacosWebHookConfigOperation;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.apache.eventmesh.webhook.config.AdminConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminWebHookConfigOperationManager {
    private static final Logger log = LoggerFactory.getLogger(AdminWebHookConfigOperationManager.class);
    private static final transient Map<String, Class<? extends WebHookConfigOperation>> WEBHOOK_CONFIG_OPERATION_MAP = new HashMap<String, Class<? extends WebHookConfigOperation>>();
    private transient AdminConfiguration adminConfiguration;
    private transient WebHookConfigOperation webHookConfigOperation;

    public WebHookConfigOperation getWebHookConfigOperation() {
        return this.webHookConfigOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        this.adminConfiguration = (AdminConfiguration)ConfigService.getInstance().buildConfigInstance(AdminConfiguration.class);
        if (!this.adminConfiguration.isAdminStart()) {
            return;
        }
        String operationMode = this.adminConfiguration.getOperationMode();
        if (!WEBHOOK_CONFIG_OPERATION_MAP.containsKey(operationMode)) {
            throw new IllegalStateException("operationMode is not supported.");
        }
        Constructor<? extends WebHookConfigOperation> constructor = WEBHOOK_CONFIG_OPERATION_MAP.get(operationMode).getDeclaredConstructor(Properties.class);
        boolean oldAccesssible = constructor.isAccessible();
        try {
            constructor.setAccessible(true);
            Properties operationProperties = this.adminConfiguration.getOperationProperties();
            if (log.isInfoEnabled()) {
                log.info("operationMode is {}  properties is {} ", (Object)operationMode, (Object)operationProperties);
            }
            this.webHookConfigOperation = constructor.newInstance(operationProperties);
        }
        finally {
            constructor.setAccessible(oldAccesssible);
        }
    }

    static {
        WEBHOOK_CONFIG_OPERATION_MAP.put("file", FileWebHookConfigOperation.class);
        WEBHOOK_CONFIG_OPERATION_MAP.put("nacos", NacosWebHookConfigOperation.class);
    }
}

