/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common;

import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SimpleMovingAverage {
    private final int[] samples;
    private long sum;
    private int count;
    private int lastIndex;

    public SimpleMovingAverage(int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"count must be a positive integer.");
        this.samples = new int[count];
        this.reset();
    }

    public void add(int value) {
        int newIndex = (this.lastIndex + 1) % this.samples.length;
        if (this.count >= this.samples.length) {
            this.sum -= (long)this.samples[newIndex];
        } else {
            ++this.count;
        }
        this.samples[newIndex] = value;
        this.sum += (long)value;
        this.lastIndex = newIndex;
    }

    public void reset() {
        this.sum = 0L;
        this.count = 0;
        this.lastIndex = -1;
    }

    public double getAverage(double defaultValue) {
        return this.count == 0 ? defaultValue : (double)this.sum / (double)this.count;
    }
}

