/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.SequentialProcessor;
import io.pravega.common.util.BlockingAsyncIterator;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;

public interface AsyncIterator<T> {
    public CompletableFuture<T> getNext();

    default public CompletableFuture<Void> forEachRemaining(Consumer<? super T> consumer, Executor executor) {
        AtomicBoolean canContinue = new AtomicBoolean(true);
        return Futures.loop(canContinue::get, this::getNext, e -> {
            if (e == null) {
                canContinue.set(false);
            } else {
                consumer.accept(e);
            }
        }, executor);
    }

    default public AsyncIterator<T> asSequential(Executor executor) {
        SequentialProcessor processor = new SequentialProcessor(executor);
        return () -> {
            CompletableFuture result = processor.add(this::getNext);
            result.thenAccept(r -> {
                if (r == null) {
                    processor.close();
                }
            });
            return result;
        };
    }

    default public CompletableFuture<Void> collectRemaining(Predicate<? super T> collector) {
        return this.getNext().thenCompose((T e) -> {
            boolean canContinue;
            boolean bl = canContinue = e != null && collector.test(e);
            if (canContinue) {
                return this.collectRemaining(collector);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    default public <U> AsyncIterator<U> thenApply(@NonNull Function<? super T, ? extends U> converter) {
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        return () -> this.getNext().thenApply((T item) -> item == null ? null : converter.apply(item));
    }

    default public <U> AsyncIterator<U> thenCompose(@NonNull Function<? super T, CompletableFuture<U>> converter) {
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        return () -> this.getNext().thenCompose((T item) -> item == null ? CompletableFuture.completedFuture(null) : (CompletionStage)converter.apply(item));
    }

    default public Iterator<T> asIterator() {
        return new BlockingAsyncIterator(this);
    }

    public static <T> AsyncIterator<T> singleton(T item) {
        AtomicBoolean returned = new AtomicBoolean(false);
        return () -> CompletableFuture.completedFuture(returned.getAndSet(true) ? null : item);
    }
}

