/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CopyOnWriteHashMap<K, V>
implements Map<K, V> {
    private volatile Map<K, V> contents;

    public CopyOnWriteHashMap() {
        this.contents = new HashMap();
    }

    public CopyOnWriteHashMap(Map<K, V> map) {
        this.contents = Collections.unmodifiableMap(map);
    }

    public Map<K, V> getInnerMap() {
        return this.contents;
    }

    @Override
    public synchronized V put(K k, V v) {
        HashMap<K, V> newMap = new HashMap<K, V>(this.contents);
        V result = newMap.put(k, v);
        this.contents = Collections.unmodifiableMap(newMap);
        return result;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> entries) {
        HashMap<? extends K, ? extends V> newMap = new HashMap<K, V>(this.contents);
        newMap.putAll(entries);
        this.contents = Collections.unmodifiableMap(newMap);
    }

    @Override
    public synchronized V putIfAbsent(K k, V v) {
        return !this.containsKey(k) ? this.put(k, v) : this.get(k);
    }

    @Override
    public synchronized V remove(Object key) {
        HashMap<K, V> newMap = new HashMap<K, V>(this.contents);
        Object result = newMap.remove(key);
        this.contents = Collections.unmodifiableMap(newMap);
        return result;
    }

    @Override
    public synchronized boolean remove(Object k, Object v) {
        if (this.containsKey(k) && this.get(k).equals(v)) {
            this.remove(k);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean replace(K k, V original, V replacement) {
        if (this.containsKey(k) && this.get(k).equals(original)) {
            this.put(k, replacement);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K k, V v) {
        return this.containsKey(k) ? (V)this.put(k, v) : null;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.contents.containsKey(k);
    }

    @Override
    public boolean containsValue(Object v) {
        return this.contents.containsValue(v);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.contents.entrySet();
    }

    @Override
    public V get(Object k) {
        return this.contents.get(k);
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.contents.keySet();
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public Collection<V> values() {
        return this.contents.values();
    }

    @Override
    public synchronized void clear() {
        this.contents = new HashMap();
    }
}

