/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.push;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Sets;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.ClientRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.http.push.AbstractHTTPPushRequest;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.WebhookUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHTTPPushRequest
extends AbstractHTTPPushRequest {
    public static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    public static final Logger CMD_LOGGER = LoggerFactory.getLogger((String)"cmd");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"AsyncHTTPPushRequest");
    public String currPushUrl;
    private final Map<String, Set<AbstractHTTPPushRequest>> waitingRequests;

    public AsyncHTTPPushRequest(HandleMsgContext handleMsgContext, Map<String, Set<AbstractHTTPPushRequest>> waitingRequests) {
        super(handleMsgContext);
        this.waitingRequests = waitingRequests;
    }

    @Override
    public void tryHTTPRequest() {
        block15: {
            this.currPushUrl = this.getUrl();
            if (StringUtils.isBlank((CharSequence)this.currPushUrl)) {
                return;
            }
            HttpPost builder = new HttpPost(this.currPushUrl);
            String requestCode = "";
            requestCode = SubscriptionType.SYNC == this.handleMsgContext.getSubscriptionItem().getType() ? String.valueOf(RequestCode.HTTP_PUSH_CLIENT_SYNC.getRequestCode()) : String.valueOf(RequestCode.HTTP_PUSH_CLIENT_ASYNC.getRequestCode());
            String localAddress = IPUtils.getLocalAddress();
            builder.addHeader("code", requestCode);
            builder.addHeader("language", "JAVA");
            builder.addHeader("version", ProtocolVersion.V1.getVersion());
            builder.addHeader("eventmeshcluster", this.handleMsgContext.getEventMeshHTTPServer().getEventMeshHttpConfiguration().getEventMeshCluster());
            builder.addHeader("eventmeship", localAddress);
            builder.addHeader("eventmeshenv", this.handleMsgContext.getEventMeshHTTPServer().getEventMeshHttpConfiguration().getEventMeshEnv());
            builder.addHeader("eventmeshidc", this.handleMsgContext.getEventMeshHTTPServer().getEventMeshHttpConfiguration().getEventMeshIDC());
            CloudEvent event = CloudEventBuilder.from((CloudEvent)this.handleMsgContext.getEvent()).withExtension("reqeventmesh2ctimestamp", String.valueOf(System.currentTimeMillis())).withExtension("rsp0url", this.currPushUrl).withExtension("rsp0group", this.handleMsgContext.getConsumerGroup()).build();
            this.handleMsgContext.setEvent(event);
            String content = "";
            try {
                String protocolType = Objects.requireNonNull(event.getExtension("protocoltype")).toString();
                ProtocolAdaptor protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
                ProtocolTransportObject protocolTransportObject = protocolAdaptor.fromCloudEvent(this.handleMsgContext.getEvent());
                if (protocolTransportObject instanceof HttpCommand) {
                    content = ((HttpCommand)protocolTransportObject).getBody().toMap().get("content").toString();
                } else {
                    HttpEventWrapper httpEventWrapper = (HttpEventWrapper)protocolTransportObject;
                    content = new String(httpEventWrapper.getBody(), Constants.DEFAULT_CHARSET);
                    httpEventWrapper.getSysHeaderMap().forEach((k, v) -> {
                        if (!builder.containsHeader(k)) {
                            builder.addHeader(k, v.toString());
                        }
                    });
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to convert EventMeshMessage from CloudEvent", (Throwable)ex);
                return;
            }
            ArrayList<BasicNameValuePair> body = new ArrayList<BasicNameValuePair>();
            body.add(new BasicNameValuePair("content", content));
            if (StringUtils.isBlank((CharSequence)this.handleMsgContext.getBizSeqNo())) {
                body.add(new BasicNameValuePair("bizseqno", RandomStringUtils.generateNum((int)20)));
            } else {
                body.add(new BasicNameValuePair("bizseqno", this.handleMsgContext.getBizSeqNo()));
            }
            if (StringUtils.isBlank((CharSequence)this.handleMsgContext.getUniqueId())) {
                body.add(new BasicNameValuePair("uniqueId", RandomStringUtils.generateNum((int)20)));
            } else {
                body.add(new BasicNameValuePair("uniqueId", this.handleMsgContext.getUniqueId()));
            }
            body.add(new BasicNameValuePair("randomNo", this.handleMsgContext.getMsgRandomNo()));
            body.add(new BasicNameValuePair("topic", this.handleMsgContext.getTopic()));
            body.add(new BasicNameValuePair("extFields", JsonUtils.toJSONString(EventMeshUtil.getEventProp(this.handleMsgContext.getEvent()))));
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(body, Constants.DEFAULT_CHARSET);
            builder.setEntity((HttpEntity)httpEntity);
            String urlAuthType = this.handleMsgContext.getConsumerGroupConfig().getConsumerGroupTopicConf().get(this.handleMsgContext.getTopic()).getHttpAuthTypeMap().get(this.currPushUrl);
            WebhookUtil.setWebhookHeaders(builder, httpEntity.getContentType().getValue(), this.eventMeshHttpConfiguration.getEventMeshWebhookOrigin(), urlAuthType);
            this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordPushMsg();
            this.lastPushTime = System.currentTimeMillis();
            this.addToWaitingMap(this);
            if (CMD_LOGGER.isInfoEnabled()) {
                CMD_LOGGER.info("cmd={}|eventMesh2client|from={}|to={}", new Object[]{requestCode, localAddress, this.currPushUrl});
            }
            try {
                this.eventMeshHTTPServer.getHttpClientPool().getClient().execute((HttpUriRequest)builder, response -> {
                    this.removeWaitingMap(this);
                    long cost = System.currentTimeMillis() - this.lastPushTime;
                    this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHTTPPushTimeCost(cost);
                    if (this.processResponseStatus(response.getStatusLine().getStatusCode(), response)) {
                        String res;
                        try {
                            res = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName(EventMeshConstants.DEFAULT_CHARSET));
                        }
                        catch (IOException e) {
                            this.handleMsgContext.finish();
                            return new Object();
                        }
                        ClientRetCode result = this.processResponseContent(res);
                        if (MESSAGE_LOGGER.isInfoEnabled()) {
                            MESSAGE_LOGGER.info("message|eventMesh2client|{}|url={}|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{result, this.currPushUrl, this.handleMsgContext.getTopic(), this.handleMsgContext.getBizSeqNo(), this.handleMsgContext.getUniqueId(), cost});
                        }
                        switch (result) {
                            case OK: 
                            case REMOTE_OK: 
                            case FAIL: {
                                this.complete();
                                if (!this.isComplete()) break;
                                this.handleMsgContext.finish();
                                break;
                            }
                            case RETRY: 
                            case NOLISTEN: {
                                this.delayRetry();
                                if (!this.isComplete()) break;
                                this.handleMsgContext.finish();
                                break;
                            }
                        }
                    } else {
                        this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHttpPushMsgFailed();
                        if (MESSAGE_LOGGER.isInfoEnabled()) {
                            MESSAGE_LOGGER.info("message|eventMesh2client|exception|url={}|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{this.currPushUrl, this.handleMsgContext.getTopic(), this.handleMsgContext.getBizSeqNo(), this.handleMsgContext.getUniqueId(), cost});
                        }
                        if (this.isComplete()) {
                            this.handleMsgContext.finish();
                        }
                    }
                    return new Object();
                });
                if (MESSAGE_LOGGER.isDebugEnabled()) {
                    MESSAGE_LOGGER.debug("message|eventMesh2client|url={}|topic={}|event={}", new Object[]{this.currPushUrl, this.handleMsgContext.getTopic(), this.handleMsgContext.getEvent()});
                } else if (MESSAGE_LOGGER.isInfoEnabled()) {
                    MESSAGE_LOGGER.info("message|eventMesh2client|url={}|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{this.currPushUrl, this.handleMsgContext.getTopic(), this.handleMsgContext.getBizSeqNo(), this.handleMsgContext.getUniqueId()});
                }
            }
            catch (IOException e) {
                MESSAGE_LOGGER.error("push2client err", (Throwable)e);
                this.removeWaitingMap(this);
                this.delayRetry();
                if (!this.isComplete()) break block15;
                this.handleMsgContext.finish();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("asyncPushRequest={").append("bizSeqNo=").append(this.handleMsgContext.getBizSeqNo()).append(",startIdx=").append(this.startIdx).append(",retryTimes=").append(this.retryTimes).append(",uniqueId=").append(this.handleMsgContext.getUniqueId()).append(",executeTime=").append(DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append(",lastPushTime=").append(DateFormatUtils.format((long)this.lastPushTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append(",createTime=").append(DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append("}");
        return sb.toString();
    }

    boolean processResponseStatus(int httpStatus, HttpResponse httpResponse) {
        if (httpStatus == 200 || httpStatus == 201 || httpStatus == 204 || httpStatus == 202) {
            return true;
        }
        if (httpStatus == 429) {
            Optional<Header> optHeader = Arrays.stream(httpResponse.getHeaders("Retry-After")).findAny();
            if (optHeader.isPresent() && StringUtils.isNumeric((CharSequence)optHeader.get().getValue())) {
                this.delayRetry(Long.parseLong(optHeader.get().getValue()));
            }
            return false;
        }
        if (httpStatus == 410 || httpStatus == 415) {
            return false;
        }
        this.delayRetry();
        return false;
    }

    ClientRetCode processResponseContent(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return ClientRetCode.FAIL;
        }
        try {
            Map ret = (Map)JsonUtils.parseTypeReferenceObject((String)content, (TypeReference)new TypeReference<Map<String, Object>>(){});
            Integer retCode = (Integer)Objects.requireNonNull(ret).get("retCode");
            if (retCode != null && ClientRetCode.contains((Integer)retCode)) {
                return ClientRetCode.get((Integer)retCode);
            }
            return ClientRetCode.FAIL;
        }
        catch (NumberFormatException e) {
            if (MESSAGE_LOGGER.isWarnEnabled()) {
                MESSAGE_LOGGER.warn("url:{}, bizSeqno:{}, uniqueId:{}, httpResponse:{}", new Object[]{this.currPushUrl, this.handleMsgContext.getBizSeqNo(), this.handleMsgContext.getUniqueId(), content});
            }
            return ClientRetCode.FAIL;
        }
        catch (Exception e) {
            if (MESSAGE_LOGGER.isWarnEnabled()) {
                MESSAGE_LOGGER.warn("url:{}, bizSeqno:{}, uniqueId:{},  httpResponse:{}", new Object[]{this.currPushUrl, this.handleMsgContext.getBizSeqNo(), this.handleMsgContext.getUniqueId(), content});
            }
            return ClientRetCode.FAIL;
        }
    }

    private void addToWaitingMap(AsyncHTTPPushRequest request) {
        if (this.waitingRequests.containsKey(request.handleMsgContext.getConsumerGroup())) {
            this.waitingRequests.get(request.handleMsgContext.getConsumerGroup()).add(request);
            return;
        }
        this.waitingRequests.put(request.handleMsgContext.getConsumerGroup(), Sets.newConcurrentHashSet());
        this.waitingRequests.get(request.handleMsgContext.getConsumerGroup()).add(request);
    }

    private void removeWaitingMap(AsyncHTTPPushRequest request) {
        if (this.waitingRequests.containsKey(request.handleMsgContext.getConsumerGroup())) {
            this.waitingRequests.get(request.handleMsgContext.getConsumerGroup()).remove(request);
        }
    }

    @Override
    public void retry() {
        this.tryHTTPRequest();
    }
}

