/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus.metrics;

import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.Meter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.eventmesh.metrics.api.model.GrpcSummaryMetrics;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.prometheus.utils.PrometheusExporterUtils;

public final class PrometheusGrpcExporter {
    private static Map<String[], Function<GrpcSummaryMetrics, Number>> paramPairs = new HashMap<String[], Function<GrpcSummaryMetrics, Number>>(){
        {
            this.put(PrometheusExporterUtils.join("sub.topic.num", "get sub topic num."), GrpcSummaryMetrics::getSubscribeTopicNum);
            this.put(PrometheusExporterUtils.join("retry.queue.size", "get size of retry queue."), GrpcSummaryMetrics::getRetrySize);
            this.put(PrometheusExporterUtils.join("server.tps", "get size of retry queue."), GrpcSummaryMetrics::getClient2EventMeshTPS);
            this.put(PrometheusExporterUtils.join("client.tps", "get tps of eventMesh to mq."), GrpcSummaryMetrics::getEventMesh2ClientTPS);
            this.put(PrometheusExporterUtils.join("mq.provider.tps", "get tps of eventMesh to mq."), GrpcSummaryMetrics::getEventMesh2MqTPS);
            this.put(PrometheusExporterUtils.join("mq.consumer.tps", "get tps of eventMesh to mq."), GrpcSummaryMetrics::getMq2EventMeshTPS);
        }
    };

    public static void export(String meterName, GrpcSummaryMetrics summaryMetrics) {
        Meter meter = GlobalMeterProvider.getMeter((String)meterName);
        paramPairs.forEach((metricInfo, getMetric) -> PrometheusExporterUtils.observeOfValue(meter, "eventmesh.grpc." + metricInfo[0], metricInfo[1], "GRPC", (Metric)summaryMetrics, getMetric));
    }

    private PrometheusGrpcExporter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

