/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.misc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.redisson.api.RLiveObject;
import org.redisson.cache.LRUCacheMap;

public class ClassUtils {
    private static final Object NO_FIELD = new Object();
    private static final Map<String, Object> FIELD_CACHE = new LRUCacheMap<String, Object>(1000, 0L, 0L);
    private static final Map<Class<?>, Boolean> ANNOTATED_CLASSES = new LRUCacheMap(500, 0L, 0L);

    public static void setField(Object obj, String fieldName, Object value) {
        try {
            Field field = ClassUtils.getDeclaredField(obj.getClass(), fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, String fieldName, Class<T> annotationClass) {
        try {
            Field field = ClassUtils.getDeclaredField(clazz, fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.getAnnotation(annotationClass);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        for (Class<?> c : ClassUtils.getClassHierarchy(clazz)) {
            if (c.getAnnotation(annotationClass) == null) continue;
            return c.getAnnotation(annotationClass);
        }
        return null;
    }

    public static <T> T getField(Object obj, String fieldName) {
        try {
            Field field = ClassUtils.getDeclaredField(obj.getClass(), fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Object field = FIELD_CACHE.get(clazz.getName() + ":" + fieldName);
        if (field == null) {
            for (Class<?> c : ClassUtils.getClassHierarchy(clazz)) {
                for (Field f : c.getDeclaredFields()) {
                    if (!f.getName().equals(fieldName)) continue;
                    FIELD_CACHE.put(clazz.getName() + ":" + fieldName, f);
                    return f;
                }
            }
        }
        if (field instanceof Field) {
            return (Field)field;
        }
        if (field == null) {
            FIELD_CACHE.put(clazz.getName() + ":" + fieldName, NO_FIELD);
        }
        throw new NoSuchFieldException("No such field: " + fieldName);
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) {
        if (clazz.getName().startsWith("java.")) {
            return false;
        }
        Boolean isAnnotated = ANNOTATED_CLASSES.get(clazz);
        if (isAnnotated == null) {
            for (Class<?> c : ClassUtils.getClassHierarchy(clazz)) {
                if (!c.isAnnotationPresent(annotation)) continue;
                ANNOTATED_CLASSES.put(clazz, true);
                return true;
            }
            ANNOTATED_CLASSES.put(clazz, false);
            return false;
        }
        return isAnnotated;
    }

    private static Iterable<Class<?>> getClassHierarchy(Class<?> clazz) {
        if (Arrays.asList(clazz.getInterfaces()).contains(RLiveObject.class)) {
            return Collections.singleton(clazz);
        }
        ArrayList classes = new ArrayList();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            classes.add(c);
        }
        return classes;
    }

    public static Method searchForMethod(Class<?> type, String name, Class<?>[] parms) {
        try {
            return type.getMethod(name, parms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method[] methods = type.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] types;
                if (!methods[i].getName().equals(name) || (types = methods[i].getParameterTypes()).length != parms.length || !ClassUtils.areTypesCompatible(types, parms)) continue;
                return methods[i];
            }
            return null;
        }
    }

    private static boolean areTypesCompatible(Class<?>[] targets, Class<?>[] sources) {
        if (targets.length != sources.length) {
            return false;
        }
        for (int i = 0; i < targets.length; ++i) {
            if (sources[i] == null || ClassUtils.translateFromPrimitive(targets[i]).isAssignableFrom(sources[i])) continue;
            return false;
        }
        return true;
    }

    private static Class<?> translateFromPrimitive(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        throw new RuntimeException("Error translating type:" + primitive);
    }
}

