/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.navercorp.pinpoint.rpc.packet.stream.StreamClosePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCode;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreatePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreateSuccessPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPingPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPongPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamResponsePacket;
import com.navercorp.pinpoint.rpc.stream.AbstractStreamChannel;
import com.navercorp.pinpoint.rpc.stream.LoggingStreamChannelStateChangeEventHandler;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageHandler;
import com.navercorp.pinpoint.rpc.stream.StreamChannelRepository;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateChangeEventHandler;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateCode;
import com.navercorp.pinpoint.rpc.stream.StreamException;
import java.net.SocketAddress;
import java.util.Objects;
import org.jboss.netty.channel.Channel;

public class ServerStreamChannel
extends AbstractStreamChannel {
    private final Channel channel;
    private final ServerStreamChannelMessageHandler streamChannelMessageHandler;
    private StreamChannelStateChangeEventHandler stateChangeEventHandler = new LoggingStreamChannelStateChangeEventHandler();

    public ServerStreamChannel(Channel channel, int streamId, StreamChannelRepository streamChannelRepository, ServerStreamChannelMessageHandler streamChannelMessageHandler) {
        super(streamId, streamChannelRepository);
        this.channel = Objects.requireNonNull(channel, "channel");
        this.streamChannelMessageHandler = Objects.requireNonNull(streamChannelMessageHandler, "streamChannelMessageHandler");
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    @Override
    public void sendPing(int requestId) {
        StreamPingPacket packet = new StreamPingPacket(this.getStreamId(), requestId);
        this.write(StreamChannelStateCode.CONNECTED, packet);
    }

    @Override
    public void sendPong(int requestId) {
        StreamPongPacket packet = new StreamPongPacket(this.getStreamId(), requestId);
        this.write(StreamChannelStateCode.CONNECTED, packet);
    }

    @Override
    public void close(StreamCode code) {
        this.clearStreamChannelResource();
        if (!StreamCode.isConnectionError(code)) {
            try {
                StreamClosePacket packet = new StreamClosePacket(this.getStreamId(), code);
                this.write(packet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void write(StreamPacket packet) {
        this.write(null, packet);
    }

    private void write(StreamChannelStateCode expectedCode, StreamPacket packet) {
        if (expectedCode != null) {
            this.state.assertState(expectedCode);
        }
        this.channel.write((Object)packet);
    }

    public void setStateChangeEventHandler(StreamChannelStateChangeEventHandler stateChangeEventHandler) {
        this.stateChangeEventHandler = Objects.requireNonNull(stateChangeEventHandler, "stateChangeEventHandler");
    }

    public void sendData(byte[] payload) {
        StreamResponsePacket packet = new StreamResponsePacket(this.getStreamId(), payload);
        this.write(StreamChannelStateCode.CONNECTED, packet);
    }

    public void sendCreateSuccess() {
        StreamCreateSuccessPacket packet = new StreamCreateSuccessPacket(this.getStreamId());
        this.write(StreamChannelStateCode.CONNECTED, packet);
    }

    public void handleStreamCreatePacket(StreamCreatePacket packet) throws StreamException {
        this.changeStateTo(StreamChannelStateCode.CONNECT_ARRIVED, true);
        StreamCode result = this.streamChannelMessageHandler.handleStreamCreatePacket(this, packet);
        if (result != StreamCode.OK) {
            throw new StreamException(result);
        }
        this.changeStateConnected();
        this.sendCreateSuccess();
    }

    @Override
    public void handleStreamClosePacket(StreamClosePacket packet) {
        this.streamChannelMessageHandler.handleStreamClosePacket(this, packet);
        this.disconnect(packet.getCode());
    }

    @Override
    public StreamChannelStateChangeEventHandler getStateChangeEventHandler() {
        return this.stateChangeEventHandler;
    }
}

