/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.redis.consumer;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.storage.redis.client.RedissonClient;
import org.redisson.Redisson;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(RedisConsumer.class);
    private Redisson redisson;
    private EventMeshMessageListener messageListener;
    private volatile boolean started = false;

    public boolean isStarted() {
        return this.started;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.redisson = null;
            this.messageListener = null;
            this.started = false;
        }
    }

    public void init(Properties keyValue) {
        this.redisson = RedissonClient.INSTANCE;
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
    }

    public void subscribe(String topic) {
        Preconditions.checkNotNull((Object)topic);
        Preconditions.checkNotNull((Object)this.messageListener);
        this.redisson.getTopic(topic).addListenerAsync(CloudEvent.class, (MessageListener)this.messageListener);
    }

    public void unsubscribe(String topic) {
        Preconditions.checkNotNull((Object)topic);
        Preconditions.checkNotNull((Object)this.messageListener);
        this.redisson.getTopic(topic).removeListenerAsync((MessageListener)this.messageListener);
    }

    public void registerEventListener(EventListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.messageListener = new EventMeshMessageListener(listener);
    }

    static class EventMeshMessageListener
    implements MessageListener<CloudEvent> {
        private final EventListener listener;

        EventMeshMessageListener(EventListener listener) {
            this.listener = listener;
        }

        public void onMessage(final CharSequence channel, final CloudEvent msg) {
            EventMeshAsyncConsumeContext consumeContext = new EventMeshAsyncConsumeContext(){

                public void commit(EventMeshAction action) {
                    log.info("channel: {} consumer event: {} finish action: {}", new Object[]{channel, msg.getId(), action});
                }
            };
            this.listener.consume(msg, (AsyncConsumeContext)consumeContext);
        }
    }
}

