/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaignStatus;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaignType;
import org.apache.fineract.infrastructure.campaigns.email.domain.ScheduledEmailAttachmentFileFormat;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.dataqueries.domain.Report;
import org.apache.fineract.useradministration.domain.AppUser;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="scheduled_email_campaign")
public class EmailCampaign
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="campaign_name", nullable=false)
    private String campaignName;
    @Column(name="campaign_type", nullable=false)
    private Integer campaignType;
    @ManyToOne
    @JoinColumn(name="business_rule_id", nullable=false)
    private Report businessRuleId;
    @Column(name="param_value")
    private String paramValue;
    @Column(name="status_enum", nullable=false)
    private Integer status;
    @Column(name="email_subject", nullable=false)
    private String emailSubject;
    @Column(name="email_message", nullable=false)
    private String emailMessage;
    @Column(name="email_attachment_file_format")
    private String emailAttachmentFileFormat;
    @ManyToOne
    @JoinColumn(name="stretchy_report_id")
    private Report stretchyReport;
    @Column(name="stretchy_report_param_map", nullable=true)
    private String stretchyReportParamMap;
    @Column(name="closedon_date", nullable=true)
    private LocalDate closureDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="closedon_userid", nullable=true)
    private AppUser closedBy;
    @Column(name="submittedon_date", nullable=true)
    private LocalDate submittedOnDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="submittedon_userid", nullable=true)
    private AppUser submittedBy;
    @Column(name="approvedon_date", nullable=true)
    private LocalDate approvedOnDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="approvedon_userid", nullable=true)
    private AppUser approvedBy;
    @Column(name="recurrence")
    private String recurrence;
    @Column(name="next_trigger_date")
    private LocalDateTime nextTriggerDate;
    @Column(name="last_trigger_date")
    private LocalDateTime lastTriggerDate;
    @Column(name="recurrence_start_date")
    private LocalDateTime recurrenceStartDate;
    @Column(name="is_visible", nullable=true)
    private boolean isVisible;
    @Column(name="previous_run_status", nullable=true)
    private String previousRunStatus;
    @Column(name="previous_run_error_log", nullable=true)
    private String previousRunErrorLog;
    @Column(name="previous_run_error_message", nullable=true)
    private String previousRunErrorMessage;
    static final long serialVersionUID = -3121307427212528926L;

    public static EmailCampaign instance(AppUser submittedBy, Report businessRuleId, Report stretchyReport, JsonCommand command) {
        String campaignName = command.stringValueOfParameterNamed("campaignName");
        Long campaignType = command.longValueOfParameterNamed("campaignType");
        String paramValue = command.stringValueOfParameterNamed("paramValue");
        String emailSubject = command.stringValueOfParameterNamed("emailSubject");
        String emailMessage = command.stringValueOfParameterNamed("emailMessage");
        String stretchyReportParamMap = command.stringValueOfParameterNamed("stretchyReportParamMap");
        Integer emailAttachmentFileFormatId = command.integerValueOfParameterNamed("emailAttachmentFileFormatId");
        ScheduledEmailAttachmentFileFormat emailAttachmentFileFormat = emailAttachmentFileFormatId != null ? ScheduledEmailAttachmentFileFormat.instance((Integer)emailAttachmentFileFormatId) : ScheduledEmailAttachmentFileFormat.instance((Integer)2);
        LocalDate submittedOnDate = DateUtils.getBusinessLocalDate();
        if (command.hasParameter("submittedOnDate")) {
            submittedOnDate = command.localDateValueOfParameterNamed("submittedOnDate");
        }
        String recurrence = command.stringValueOfParameterNamed("recurrence");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDateTime recurrenceStartDate = DateUtils.getLocalDateTimeOfTenant();
        if (EmailCampaignType.fromInt((Integer)campaignType.intValue()).isSchedule()) {
            if (command.hasParameter("recurrenceStartDate")) {
                recurrenceStartDate = LocalDateTime.parse(command.stringValueOfParameterNamed("recurrenceStartDate"), fmt);
            }
        } else {
            recurrenceStartDate = null;
        }
        return new EmailCampaign().setCampaignName(campaignName).setCampaignType(Integer.valueOf(campaignType.intValue())).setBusinessRuleId(businessRuleId).setParamValue(paramValue).setStatus(EmailCampaignStatus.PENDING.getValue()).setEmailSubject(emailSubject).setEmailMessage(emailMessage).setSubmittedOnDate(submittedOnDate).setSubmittedBy(submittedBy).setStretchyReport(stretchyReport).setEmailAttachmentFileFormat(emailAttachmentFileFormat.getValue()).setRecurrence(recurrence).setRecurrenceStartDate(recurrenceStartDate).setStretchyReportParamMap(stretchyReportParamMap);
    }

    public Map<String, Object> update(JsonCommand command) {
        Object newValue;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(5);
        if (command.isChangeInStringParameterNamed("campaignName", this._persistence_get_campaignName())) {
            newValue = command.stringValueOfParameterNamed("campaignName");
            actualChanges.put("campaignName", newValue);
            this._persistence_set_campaignName((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInStringParameterNamed("emailMessage", this._persistence_get_emailMessage())) {
            newValue = command.stringValueOfParameterNamed("emailMessage");
            actualChanges.put("emailMessage", newValue);
            this._persistence_set_emailMessage((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInStringParameterNamed("paramValue", this._persistence_get_paramValue())) {
            newValue = command.stringValueOfParameterNamed("paramValue");
            actualChanges.put("paramValue", newValue);
            this._persistence_set_paramValue((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInIntegerParameterNamed("campaignType", this._persistence_get_campaignType())) {
            newValue = command.integerValueOfParameterNamed("campaignType");
            actualChanges.put("campaignType", EmailCampaignType.fromInt((Integer)newValue));
            this._persistence_set_campaignType(EmailCampaignType.fromInt((Integer)newValue).getValue());
        }
        if (command.isChangeInLongParameterNamed("businessRuleId", this._persistence_get_businessRuleId() != null ? (Long)this._persistence_get_businessRuleId().getId() : null)) {
            newValue = command.stringValueOfParameterNamed("businessRuleId");
            actualChanges.put("businessRuleId", newValue);
        }
        if (command.isChangeInStringParameterNamed("recurrence", this._persistence_get_recurrence())) {
            newValue = command.stringValueOfParameterNamed("recurrence");
            actualChanges.put("recurrence", newValue);
            this._persistence_set_recurrence((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        String dateFormatAsInput = command.dateFormat();
        String localeAsInput = command.locale();
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        if (command.isChangeInLocalDateTimeParameterNamed("recurrenceStartDate", this.getRecurrenceStartDate())) {
            String valueAsInput = command.stringValueOfParameterNamed("recurrenceStartDate");
            actualChanges.put("recurrenceStartDate", valueAsInput);
            actualChanges.put("dateFormat", dateFormatAsInput);
            actualChanges.put("locale", localeAsInput);
            this._persistence_set_recurrenceStartDate(LocalDateTime.parse(valueAsInput, fmt));
        }
        return actualChanges;
    }

    public void activate(AppUser currentUser, DateTimeFormatter formatter, LocalDate activationLocalDate) {
        if (this.isActive()) {
            String defaultUserMessage = "Cannot activate campaign. Campaign is already active.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.campaign.already.active", (String)"Cannot activate campaign. Campaign is already active.", (String)"activationDate", (Object[])new Object[]{activationLocalDate.format(formatter)});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        this._persistence_set_approvedOnDate(activationLocalDate);
        this._persistence_set_approvedBy(currentUser);
        this._persistence_set_status(EmailCampaignStatus.ACTIVE.getValue());
        this.validate();
    }

    public void close(AppUser currentUser, DateTimeFormatter dateTimeFormatter, LocalDate closureLocalDate) {
        if (this.isClosed()) {
            String defaultUserMessage = "Cannot close campaign. Campaign already in closed state.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.campaign.already.closed", (String)"Cannot close campaign. Campaign already in closed state.", (String)"status", (Object[])new Object[]{EmailCampaignStatus.fromInt((Integer)this._persistence_get_status()).getCode()});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        if (this._persistence_get_campaignType().intValue() == EmailCampaignType.SCHEDULE.getValue().intValue()) {
            this._persistence_set_nextTriggerDate(null);
            this._persistence_set_lastTriggerDate(null);
        }
        this._persistence_set_closedBy(currentUser);
        this._persistence_set_closureDate(closureLocalDate);
        this._persistence_set_status(EmailCampaignStatus.CLOSED.getValue());
        this.validateClosureDate();
    }

    public void reactivate(AppUser currentUser, DateTimeFormatter dateTimeFormat, LocalDate reactivateLocalDate) {
        if (!this.isClosed()) {
            String defaultUserMessage = "Cannot reactivate campaign. Campaign must be in closed state.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.campaign.must.be.closed", (String)"Cannot reactivate campaign. Campaign must be in closed state.", (String)"status", (Object[])new Object[]{EmailCampaignStatus.fromInt((Integer)this._persistence_get_status()).getCode()});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        this._persistence_set_approvedOnDate(reactivateLocalDate);
        this._persistence_set_status(EmailCampaignStatus.ACTIVE.getValue());
        this._persistence_set_approvedBy(currentUser);
        this._persistence_set_isVisible(true);
        this.validateReactivate();
    }

    public void delete() {
        if (!this.isClosed()) {
            String defaultUserMessage = "Cannot delete campaign. Campaign must be in closed state.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.campaign.must.be.closed", (String)"Cannot delete campaign. Campaign must be in closed state.", (String)"status", (Object[])new Object[]{EmailCampaignStatus.fromInt((Integer)this._persistence_get_status()).getCode()});
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        this._persistence_set_isVisible(false);
    }

    public boolean isActive() {
        return EmailCampaignStatus.fromInt((Integer)this._persistence_get_status()).isActive();
    }

    public boolean isPending() {
        return EmailCampaignStatus.fromInt((Integer)this._persistence_get_status()).isPending();
    }

    public boolean isClosed() {
        return EmailCampaignStatus.fromInt((Integer)this._persistence_get_status()).isClosed();
    }

    public boolean isDirect() {
        return EmailCampaignType.fromInt((Integer)this._persistence_get_campaignType()).isDirect();
    }

    public boolean isSchedule() {
        return EmailCampaignType.fromInt((Integer)this._persistence_get_campaignType()).isSchedule();
    }

    private void validate() {
        ArrayList dataValidationErrors = new ArrayList();
        this.validateActivationDate(dataValidationErrors);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateReactivate() {
        ArrayList dataValidationErrors = new ArrayList();
        this.validateReactivationDate(dataValidationErrors);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateClosureDate() {
        ArrayList dataValidationErrors = new ArrayList();
        this.validateClosureDate(dataValidationErrors);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateActivationDate(List<ApiParameterError> dataValidationErrors) {
        ApiParameterError error;
        String defaultUserMessage;
        if (this.getSubmittedOnDate() != null && DateUtils.isDateInTheFuture((LocalDate)this.getSubmittedOnDate())) {
            defaultUserMessage = "submitted date cannot be in the future.";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.submittedOnDate.in.the.future", (String)"submitted date cannot be in the future.", (String)"submittedOnDate", (Object[])new Object[]{this._persistence_get_submittedOnDate()});
            dataValidationErrors.add(error);
        }
        if (this.getApprovedOnDate() != null && DateUtils.isAfter((LocalDate)this.getSubmittedOnDate(), (LocalDate)this.getApprovedOnDate())) {
            defaultUserMessage = "submitted date cannot be after the activation date";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.submittedOnDate.after.activation.date", (String)"submitted date cannot be after the activation date", (String)"submittedOnDate", (Object[])new Object[]{this._persistence_get_submittedOnDate()});
            dataValidationErrors.add(error);
        }
        if (DateUtils.isDateInTheFuture((LocalDate)this.getApprovedOnDate())) {
            defaultUserMessage = "Activation date cannot be in the future.";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.activationDate.in.the.future", (String)"Activation date cannot be in the future.", (String)"activationDate", (Object[])new Object[]{this.getApprovedOnDate()});
            dataValidationErrors.add(error);
        }
    }

    private void validateReactivationDate(List<ApiParameterError> dataValidationErrors) {
        ApiParameterError error;
        String defaultUserMessage;
        if (DateUtils.isDateInTheFuture((LocalDate)this.getApprovedOnDate())) {
            defaultUserMessage = "Activation date cannot be in the future.";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.activationDate.in.the.future", (String)"Activation date cannot be in the future.", (String)"activationDate", (Object[])new Object[]{this.getApprovedOnDate()});
            dataValidationErrors.add(error);
        }
        if (this.getApprovedOnDate() != null && DateUtils.isAfter((LocalDate)this.getSubmittedOnDate(), (LocalDate)this.getApprovedOnDate())) {
            defaultUserMessage = "submitted date cannot be after the activation date";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.submittedOnDate.after.activation.date", (String)"submitted date cannot be after the activation date", (String)"submittedOnDate", (Object[])new Object[]{this._persistence_get_submittedOnDate()});
            dataValidationErrors.add(error);
        }
        if (DateUtils.isDateInTheFuture((LocalDate)this.getSubmittedOnDate())) {
            defaultUserMessage = "submitted date cannot be in the future.";
            error = ApiParameterError.parameterError((String)"error.msg.campaign.submittedOnDate.in.the.future", (String)"submitted date cannot be in the future.", (String)"submittedOnDate", (Object[])new Object[]{this._persistence_get_submittedOnDate()});
            dataValidationErrors.add(error);
        }
    }

    private void validateClosureDate(List<ApiParameterError> dataValidationErrors) {
        if (this.getClosureDate() != null && DateUtils.isDateInTheFuture((LocalDate)this.getClosureDate())) {
            String defaultUserMessage = "closure date cannot be in the future.";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.campaign.closureDate.in.the.future", (String)"closure date cannot be in the future.", (String)"closureDate", (Object[])new Object[]{this._persistence_get_closureDate()});
            dataValidationErrors.add(error);
        }
    }

    @Generated
    public String getCampaignName() {
        return this._persistence_get_campaignName();
    }

    @Generated
    public Integer getCampaignType() {
        return this._persistence_get_campaignType();
    }

    @Generated
    public Report getBusinessRuleId() {
        return this._persistence_get_businessRuleId();
    }

    @Generated
    public String getParamValue() {
        return this._persistence_get_paramValue();
    }

    @Generated
    public Integer getStatus() {
        return this._persistence_get_status();
    }

    @Generated
    public String getEmailSubject() {
        return this._persistence_get_emailSubject();
    }

    @Generated
    public String getEmailMessage() {
        return this._persistence_get_emailMessage();
    }

    @Generated
    public String getEmailAttachmentFileFormat() {
        return this._persistence_get_emailAttachmentFileFormat();
    }

    @Generated
    public Report getStretchyReport() {
        return this._persistence_get_stretchyReport();
    }

    @Generated
    public String getStretchyReportParamMap() {
        return this._persistence_get_stretchyReportParamMap();
    }

    @Generated
    public LocalDate getClosureDate() {
        return this._persistence_get_closureDate();
    }

    @Generated
    public AppUser getClosedBy() {
        return this._persistence_get_closedBy();
    }

    @Generated
    public LocalDate getSubmittedOnDate() {
        return this._persistence_get_submittedOnDate();
    }

    @Generated
    public AppUser getSubmittedBy() {
        return this._persistence_get_submittedBy();
    }

    @Generated
    public LocalDate getApprovedOnDate() {
        return this._persistence_get_approvedOnDate();
    }

    @Generated
    public AppUser getApprovedBy() {
        return this._persistence_get_approvedBy();
    }

    @Generated
    public String getRecurrence() {
        return this._persistence_get_recurrence();
    }

    @Generated
    public LocalDateTime getNextTriggerDate() {
        return this._persistence_get_nextTriggerDate();
    }

    @Generated
    public LocalDateTime getLastTriggerDate() {
        return this._persistence_get_lastTriggerDate();
    }

    @Generated
    public LocalDateTime getRecurrenceStartDate() {
        return this._persistence_get_recurrenceStartDate();
    }

    @Generated
    public boolean isVisible() {
        return this._persistence_get_isVisible();
    }

    @Generated
    public String getPreviousRunStatus() {
        return this._persistence_get_previousRunStatus();
    }

    @Generated
    public String getPreviousRunErrorLog() {
        return this._persistence_get_previousRunErrorLog();
    }

    @Generated
    public String getPreviousRunErrorMessage() {
        return this._persistence_get_previousRunErrorMessage();
    }

    @Generated
    public EmailCampaign setCampaignName(String campaignName) {
        this._persistence_set_campaignName(campaignName);
        return this;
    }

    @Generated
    public EmailCampaign setCampaignType(Integer campaignType) {
        this._persistence_set_campaignType(campaignType);
        return this;
    }

    @Generated
    public EmailCampaign setBusinessRuleId(Report businessRuleId) {
        this._persistence_set_businessRuleId(businessRuleId);
        return this;
    }

    @Generated
    public EmailCampaign setParamValue(String paramValue) {
        this._persistence_set_paramValue(paramValue);
        return this;
    }

    @Generated
    public EmailCampaign setStatus(Integer status) {
        this._persistence_set_status(status);
        return this;
    }

    @Generated
    public EmailCampaign setEmailSubject(String emailSubject) {
        this._persistence_set_emailSubject(emailSubject);
        return this;
    }

    @Generated
    public EmailCampaign setEmailMessage(String emailMessage) {
        this._persistence_set_emailMessage(emailMessage);
        return this;
    }

    @Generated
    public EmailCampaign setEmailAttachmentFileFormat(String emailAttachmentFileFormat) {
        this._persistence_set_emailAttachmentFileFormat(emailAttachmentFileFormat);
        return this;
    }

    @Generated
    public EmailCampaign setStretchyReport(Report stretchyReport) {
        this._persistence_set_stretchyReport(stretchyReport);
        return this;
    }

    @Generated
    public EmailCampaign setStretchyReportParamMap(String stretchyReportParamMap) {
        this._persistence_set_stretchyReportParamMap(stretchyReportParamMap);
        return this;
    }

    @Generated
    public EmailCampaign setClosureDate(LocalDate closureDate) {
        this._persistence_set_closureDate(closureDate);
        return this;
    }

    @Generated
    public EmailCampaign setClosedBy(AppUser closedBy) {
        this._persistence_set_closedBy(closedBy);
        return this;
    }

    @Generated
    public EmailCampaign setSubmittedOnDate(LocalDate submittedOnDate) {
        this._persistence_set_submittedOnDate(submittedOnDate);
        return this;
    }

    @Generated
    public EmailCampaign setSubmittedBy(AppUser submittedBy) {
        this._persistence_set_submittedBy(submittedBy);
        return this;
    }

    @Generated
    public EmailCampaign setApprovedOnDate(LocalDate approvedOnDate) {
        this._persistence_set_approvedOnDate(approvedOnDate);
        return this;
    }

    @Generated
    public EmailCampaign setApprovedBy(AppUser approvedBy) {
        this._persistence_set_approvedBy(approvedBy);
        return this;
    }

    @Generated
    public EmailCampaign setRecurrence(String recurrence) {
        this._persistence_set_recurrence(recurrence);
        return this;
    }

    @Generated
    public EmailCampaign setNextTriggerDate(LocalDateTime nextTriggerDate) {
        this._persistence_set_nextTriggerDate(nextTriggerDate);
        return this;
    }

    @Generated
    public EmailCampaign setLastTriggerDate(LocalDateTime lastTriggerDate) {
        this._persistence_set_lastTriggerDate(lastTriggerDate);
        return this;
    }

    @Generated
    public EmailCampaign setRecurrenceStartDate(LocalDateTime recurrenceStartDate) {
        this._persistence_set_recurrenceStartDate(recurrenceStartDate);
        return this;
    }

    @Generated
    public EmailCampaign setVisible(boolean isVisible) {
        this._persistence_set_isVisible(isVisible);
        return this;
    }

    @Generated
    public EmailCampaign setPreviousRunStatus(String previousRunStatus) {
        this._persistence_set_previousRunStatus(previousRunStatus);
        return this;
    }

    @Generated
    public EmailCampaign setPreviousRunErrorLog(String previousRunErrorLog) {
        this._persistence_set_previousRunErrorLog(previousRunErrorLog);
        return this;
    }

    @Generated
    public EmailCampaign setPreviousRunErrorMessage(String previousRunErrorMessage) {
        this._persistence_set_previousRunErrorMessage(previousRunErrorMessage);
        return this;
    }

    @Generated
    public EmailCampaign() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EmailCampaign(persistenceObject);
    }

    public EmailCampaign(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "closedBy") {
            return this.closedBy;
        }
        if (string == "businessRuleId") {
            return this.businessRuleId;
        }
        if (string == "approvedBy") {
            return this.approvedBy;
        }
        if (string == "emailSubject") {
            return this.emailSubject;
        }
        if (string == "lastTriggerDate") {
            return this.lastTriggerDate;
        }
        if (string == "recurrenceStartDate") {
            return this.recurrenceStartDate;
        }
        if (string == "approvedOnDate") {
            return this.approvedOnDate;
        }
        if (string == "emailAttachmentFileFormat") {
            return this.emailAttachmentFileFormat;
        }
        if (string == "submittedOnDate") {
            return this.submittedOnDate;
        }
        if (string == "paramValue") {
            return this.paramValue;
        }
        if (string == "previousRunErrorMessage") {
            return this.previousRunErrorMessage;
        }
        if (string == "submittedBy") {
            return this.submittedBy;
        }
        if (string == "campaignType") {
            return this.campaignType;
        }
        if (string == "stretchyReportParamMap") {
            return this.stretchyReportParamMap;
        }
        if (string == "previousRunStatus") {
            return this.previousRunStatus;
        }
        if (string == "isVisible") {
            return this.isVisible;
        }
        if (string == "nextTriggerDate") {
            return this.nextTriggerDate;
        }
        if (string == "recurrence") {
            return this.recurrence;
        }
        if (string == "emailMessage") {
            return this.emailMessage;
        }
        if (string == "previousRunErrorLog") {
            return this.previousRunErrorLog;
        }
        if (string == "closureDate") {
            return this.closureDate;
        }
        if (string == "stretchyReport") {
            return this.stretchyReport;
        }
        if (string == "campaignName") {
            return this.campaignName;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "closedBy") {
            this.closedBy = (AppUser)object;
            return;
        }
        if (string == "businessRuleId") {
            this.businessRuleId = (Report)object;
            return;
        }
        if (string == "approvedBy") {
            this.approvedBy = (AppUser)object;
            return;
        }
        if (string == "emailSubject") {
            this.emailSubject = (String)object;
            return;
        }
        if (string == "lastTriggerDate") {
            this.lastTriggerDate = (LocalDateTime)object;
            return;
        }
        if (string == "recurrenceStartDate") {
            this.recurrenceStartDate = (LocalDateTime)object;
            return;
        }
        if (string == "approvedOnDate") {
            this.approvedOnDate = (LocalDate)object;
            return;
        }
        if (string == "emailAttachmentFileFormat") {
            this.emailAttachmentFileFormat = (String)object;
            return;
        }
        if (string == "submittedOnDate") {
            this.submittedOnDate = (LocalDate)object;
            return;
        }
        if (string == "paramValue") {
            this.paramValue = (String)object;
            return;
        }
        if (string == "previousRunErrorMessage") {
            this.previousRunErrorMessage = (String)object;
            return;
        }
        if (string == "submittedBy") {
            this.submittedBy = (AppUser)object;
            return;
        }
        if (string == "campaignType") {
            this.campaignType = (Integer)object;
            return;
        }
        if (string == "stretchyReportParamMap") {
            this.stretchyReportParamMap = (String)object;
            return;
        }
        if (string == "previousRunStatus") {
            this.previousRunStatus = (String)object;
            return;
        }
        if (string == "isVisible") {
            this.isVisible = (Boolean)object;
            return;
        }
        if (string == "nextTriggerDate") {
            this.nextTriggerDate = (LocalDateTime)object;
            return;
        }
        if (string == "recurrence") {
            this.recurrence = (String)object;
            return;
        }
        if (string == "emailMessage") {
            this.emailMessage = (String)object;
            return;
        }
        if (string == "previousRunErrorLog") {
            this.previousRunErrorLog = (String)object;
            return;
        }
        if (string == "closureDate") {
            this.closureDate = (LocalDate)object;
            return;
        }
        if (string == "stretchyReport") {
            this.stretchyReport = (Report)object;
            return;
        }
        if (string == "campaignName") {
            this.campaignName = (String)object;
            return;
        }
        if (string == "status") {
            this.status = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public AppUser _persistence_get_closedBy() {
        this._persistence_checkFetched("closedBy");
        return this.closedBy;
    }

    public void _persistence_set_closedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("closedBy");
        this._persistence_propertyChange("closedBy", (Object)this.closedBy, (Object)appUser);
        this.closedBy = appUser;
    }

    public Report _persistence_get_businessRuleId() {
        this._persistence_checkFetched("businessRuleId");
        return this.businessRuleId;
    }

    public void _persistence_set_businessRuleId(Report report) {
        this._persistence_checkFetchedForSet("businessRuleId");
        this._persistence_propertyChange("businessRuleId", (Object)this.businessRuleId, (Object)report);
        this.businessRuleId = report;
    }

    public AppUser _persistence_get_approvedBy() {
        this._persistence_checkFetched("approvedBy");
        return this.approvedBy;
    }

    public void _persistence_set_approvedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("approvedBy");
        this._persistence_propertyChange("approvedBy", (Object)this.approvedBy, (Object)appUser);
        this.approvedBy = appUser;
    }

    public String _persistence_get_emailSubject() {
        this._persistence_checkFetched("emailSubject");
        return this.emailSubject;
    }

    public void _persistence_set_emailSubject(String string) {
        this._persistence_checkFetchedForSet("emailSubject");
        this._persistence_propertyChange("emailSubject", (Object)this.emailSubject, (Object)string);
        this.emailSubject = string;
    }

    public LocalDateTime _persistence_get_lastTriggerDate() {
        this._persistence_checkFetched("lastTriggerDate");
        return this.lastTriggerDate;
    }

    public void _persistence_set_lastTriggerDate(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("lastTriggerDate");
        this._persistence_propertyChange("lastTriggerDate", (Object)this.lastTriggerDate, (Object)localDateTime);
        this.lastTriggerDate = localDateTime;
    }

    public LocalDateTime _persistence_get_recurrenceStartDate() {
        this._persistence_checkFetched("recurrenceStartDate");
        return this.recurrenceStartDate;
    }

    public void _persistence_set_recurrenceStartDate(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("recurrenceStartDate");
        this._persistence_propertyChange("recurrenceStartDate", (Object)this.recurrenceStartDate, (Object)localDateTime);
        this.recurrenceStartDate = localDateTime;
    }

    public LocalDate _persistence_get_approvedOnDate() {
        this._persistence_checkFetched("approvedOnDate");
        return this.approvedOnDate;
    }

    public void _persistence_set_approvedOnDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("approvedOnDate");
        this._persistence_propertyChange("approvedOnDate", (Object)this.approvedOnDate, (Object)localDate);
        this.approvedOnDate = localDate;
    }

    public String _persistence_get_emailAttachmentFileFormat() {
        this._persistence_checkFetched("emailAttachmentFileFormat");
        return this.emailAttachmentFileFormat;
    }

    public void _persistence_set_emailAttachmentFileFormat(String string) {
        this._persistence_checkFetchedForSet("emailAttachmentFileFormat");
        this._persistence_propertyChange("emailAttachmentFileFormat", (Object)this.emailAttachmentFileFormat, (Object)string);
        this.emailAttachmentFileFormat = string;
    }

    public LocalDate _persistence_get_submittedOnDate() {
        this._persistence_checkFetched("submittedOnDate");
        return this.submittedOnDate;
    }

    public void _persistence_set_submittedOnDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("submittedOnDate");
        this._persistence_propertyChange("submittedOnDate", (Object)this.submittedOnDate, (Object)localDate);
        this.submittedOnDate = localDate;
    }

    public String _persistence_get_paramValue() {
        this._persistence_checkFetched("paramValue");
        return this.paramValue;
    }

    public void _persistence_set_paramValue(String string) {
        this._persistence_checkFetchedForSet("paramValue");
        this._persistence_propertyChange("paramValue", (Object)this.paramValue, (Object)string);
        this.paramValue = string;
    }

    public String _persistence_get_previousRunErrorMessage() {
        this._persistence_checkFetched("previousRunErrorMessage");
        return this.previousRunErrorMessage;
    }

    public void _persistence_set_previousRunErrorMessage(String string) {
        this._persistence_checkFetchedForSet("previousRunErrorMessage");
        this._persistence_propertyChange("previousRunErrorMessage", (Object)this.previousRunErrorMessage, (Object)string);
        this.previousRunErrorMessage = string;
    }

    public AppUser _persistence_get_submittedBy() {
        this._persistence_checkFetched("submittedBy");
        return this.submittedBy;
    }

    public void _persistence_set_submittedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("submittedBy");
        this._persistence_propertyChange("submittedBy", (Object)this.submittedBy, (Object)appUser);
        this.submittedBy = appUser;
    }

    public Integer _persistence_get_campaignType() {
        this._persistence_checkFetched("campaignType");
        return this.campaignType;
    }

    public void _persistence_set_campaignType(Integer n) {
        this._persistence_checkFetchedForSet("campaignType");
        this._persistence_propertyChange("campaignType", (Object)this.campaignType, (Object)n);
        this.campaignType = n;
    }

    public String _persistence_get_stretchyReportParamMap() {
        this._persistence_checkFetched("stretchyReportParamMap");
        return this.stretchyReportParamMap;
    }

    public void _persistence_set_stretchyReportParamMap(String string) {
        this._persistence_checkFetchedForSet("stretchyReportParamMap");
        this._persistence_propertyChange("stretchyReportParamMap", (Object)this.stretchyReportParamMap, (Object)string);
        this.stretchyReportParamMap = string;
    }

    public String _persistence_get_previousRunStatus() {
        this._persistence_checkFetched("previousRunStatus");
        return this.previousRunStatus;
    }

    public void _persistence_set_previousRunStatus(String string) {
        this._persistence_checkFetchedForSet("previousRunStatus");
        this._persistence_propertyChange("previousRunStatus", (Object)this.previousRunStatus, (Object)string);
        this.previousRunStatus = string;
    }

    public boolean _persistence_get_isVisible() {
        this._persistence_checkFetched("isVisible");
        return this.isVisible;
    }

    public void _persistence_set_isVisible(boolean bl) {
        this._persistence_checkFetchedForSet("isVisible");
        this._persistence_propertyChange("isVisible", (Object)new Boolean(this.isVisible), (Object)new Boolean(bl));
        this.isVisible = bl;
    }

    public LocalDateTime _persistence_get_nextTriggerDate() {
        this._persistence_checkFetched("nextTriggerDate");
        return this.nextTriggerDate;
    }

    public void _persistence_set_nextTriggerDate(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("nextTriggerDate");
        this._persistence_propertyChange("nextTriggerDate", (Object)this.nextTriggerDate, (Object)localDateTime);
        this.nextTriggerDate = localDateTime;
    }

    public String _persistence_get_recurrence() {
        this._persistence_checkFetched("recurrence");
        return this.recurrence;
    }

    public void _persistence_set_recurrence(String string) {
        this._persistence_checkFetchedForSet("recurrence");
        this._persistence_propertyChange("recurrence", (Object)this.recurrence, (Object)string);
        this.recurrence = string;
    }

    public String _persistence_get_emailMessage() {
        this._persistence_checkFetched("emailMessage");
        return this.emailMessage;
    }

    public void _persistence_set_emailMessage(String string) {
        this._persistence_checkFetchedForSet("emailMessage");
        this._persistence_propertyChange("emailMessage", (Object)this.emailMessage, (Object)string);
        this.emailMessage = string;
    }

    public String _persistence_get_previousRunErrorLog() {
        this._persistence_checkFetched("previousRunErrorLog");
        return this.previousRunErrorLog;
    }

    public void _persistence_set_previousRunErrorLog(String string) {
        this._persistence_checkFetchedForSet("previousRunErrorLog");
        this._persistence_propertyChange("previousRunErrorLog", (Object)this.previousRunErrorLog, (Object)string);
        this.previousRunErrorLog = string;
    }

    public LocalDate _persistence_get_closureDate() {
        this._persistence_checkFetched("closureDate");
        return this.closureDate;
    }

    public void _persistence_set_closureDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("closureDate");
        this._persistence_propertyChange("closureDate", (Object)this.closureDate, (Object)localDate);
        this.closureDate = localDate;
    }

    public Report _persistence_get_stretchyReport() {
        this._persistence_checkFetched("stretchyReport");
        return this.stretchyReport;
    }

    public void _persistence_set_stretchyReport(Report report) {
        this._persistence_checkFetchedForSet("stretchyReport");
        this._persistence_propertyChange("stretchyReport", (Object)this.stretchyReport, (Object)report);
        this.stretchyReport = report;
    }

    public String _persistence_get_campaignName() {
        this._persistence_checkFetched("campaignName");
        return this.campaignName;
    }

    public void _persistence_set_campaignName(String string) {
        this._persistence_checkFetchedForSet("campaignName");
        this._persistence_propertyChange("campaignName", (Object)this.campaignName, (Object)string);
        this.campaignName = string;
    }

    public Integer _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(Integer n) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", (Object)this.status, (Object)n);
        this.status = n;
    }
}

