/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.jobs.updatesmsoutboundwithcampaignmessage;

import java.time.LocalDateTime;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.fineract.infrastructure.campaigns.sms.constants.SmsCampaignStatus;
import org.apache.fineract.infrastructure.campaigns.sms.constants.SmsCampaignTriggerType;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaign;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaignRepository;
import org.apache.fineract.infrastructure.campaigns.sms.exception.SmsCampaignNotFound;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignWritePlatformService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class UpdateSmsOutboundWithCampaignMessageTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateSmsOutboundWithCampaignMessageTasklet.class);
    private final SmsCampaignRepository smsCampaignRepository;
    private final SmsCampaignWritePlatformService smsCampaignWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Collection smsCampaignDataCollection = this.smsCampaignRepository.findByTriggerTypeAndStatus(SmsCampaignTriggerType.SCHEDULE.getValue(), SmsCampaignStatus.ACTIVE.getValue());
        if (!CollectionUtils.isEmpty((Collection)smsCampaignDataCollection)) {
            for (SmsCampaign smsCampaign : smsCampaignDataCollection) {
                LocalDateTime tenantDateNow = DateUtils.getLocalDateTimeOfTenant();
                LocalDateTime nextTriggerDate = smsCampaign.getNextTriggerDate();
                log.debug("tenant time {} trigger time {} {}", new Object[]{tenantDateNow, nextTriggerDate, JobName.UPDATE_SMS_OUTBOUND_WITH_CAMPAIGN_MESSAGE.name()});
                if (!DateUtils.isBefore((LocalDateTime)nextTriggerDate, (LocalDateTime)tenantDateNow)) continue;
                this.smsCampaignWritePlatformService.insertDirectCampaignIntoSmsOutboundTable(smsCampaign);
                this.updateTriggerDates((Long)smsCampaign.getId());
            }
        }
        return RepeatStatus.FINISHED;
    }

    private void updateTriggerDates(Long campaignId) {
        SmsCampaign smsCampaign = (SmsCampaign)this.smsCampaignRepository.findById((Object)campaignId).orElseThrow(() -> new SmsCampaignNotFound(campaignId));
        LocalDateTime nextTriggerDate = smsCampaign.getNextTriggerDate();
        smsCampaign.setLastTriggerDate(nextTriggerDate);
        LocalDateTime nextRuntime = CalendarUtils.getNextRecurringDate((String)smsCampaign.getRecurrence(), (LocalDateTime)nextTriggerDate, (LocalDateTime)nextTriggerDate);
        LocalDateTime tenantDateTime = DateUtils.getLocalDateTimeOfTenant();
        if (DateUtils.isBefore((LocalDateTime)nextRuntime, (LocalDateTime)tenantDateTime)) {
            nextRuntime = CalendarUtils.getNextRecurringDate((String)smsCampaign.getRecurrence(), (LocalDateTime)nextTriggerDate, (LocalDateTime)tenantDateTime);
        }
        smsCampaign.setNextTriggerDate(nextRuntime);
        this.smsCampaignRepository.saveAndFlush((Object)smsCampaign);
    }

    @Generated
    public UpdateSmsOutboundWithCampaignMessageTasklet(SmsCampaignRepository smsCampaignRepository, SmsCampaignWritePlatformService smsCampaignWritePlatformService) {
        this.smsCampaignRepository = smsCampaignRepository;
        this.smsCampaignWritePlatformService = smsCampaignWritePlatformService;
    }
}

