/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.command;

import java.util.Map;
import org.apache.fineract.commands.annotation.CommandType;
import org.apache.fineract.commands.handler.NewCommandSourceHandler;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.security.data.TwoFactorConfigurationValidator;
import org.apache.fineract.infrastructure.security.service.TwoFactorConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CommandType(entity="TWOFACTOR_CONFIGURATION", action="UPDATE")
@ConditionalOnProperty(value={"fineract.security.2fa.enabled"})
public class UpdateTwoFactorConfigCommandHandler
implements NewCommandSourceHandler {
    private final TwoFactorConfigurationService configurationService;
    private final TwoFactorConfigurationValidator dataValidator;

    @Autowired
    public UpdateTwoFactorConfigCommandHandler(TwoFactorConfigurationService configurationService, TwoFactorConfigurationValidator dataValidator) {
        this.configurationService = configurationService;
        this.dataValidator = dataValidator;
    }

    @Transactional
    public CommandProcessingResult processCommand(JsonCommand command) {
        this.dataValidator.validateForUpdate(command.json());
        Map changes = this.configurationService.update(command);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).with(changes).build();
    }
}

