/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import java.util.Map;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.interoperation.data.IdDocument;
import org.apache.fineract.interoperation.data.InteropKycData;
import org.apache.fineract.interoperation.data.PostalAddress;
import org.apache.fineract.interoperation.data.SubjectName;

public class InteropKycResponseData
extends CommandProcessingResult {
    private String nationality;
    private String dateOfBirth;
    private String contactPhone;
    private String gender;
    private IdDocument[] idDocument;
    private PostalAddress postalAddress;
    private SubjectName subjectName;
    private String emailAddress;
    private String birthCountry;

    public InteropKycResponseData(Long resourceId, Long officeId, Long commandId, Map<String, Object> changesOnly, String nationality, String dateOfBirth, String contactPhone, String gender, IdDocument[] idDocument, PostalAddress postalAddress, SubjectName subjectName, String emailAddress, String birthCountry) {
        super(resourceId, officeId, commandId, changesOnly);
        this.nationality = nationality;
        this.dateOfBirth = dateOfBirth;
        this.contactPhone = contactPhone;
        this.gender = gender;
        this.idDocument = idDocument;
        this.postalAddress = postalAddress;
        this.subjectName = subjectName;
        this.emailAddress = emailAddress;
        this.birthCountry = birthCountry;
    }

    public InteropKycResponseData(String nationality, String dateOfBirth, String contactPhone, String gender, IdDocument[] idDocument, PostalAddress postalAddress, SubjectName subjectName, String emailAddress, String birthCountry) {
        this(null, null, null, null, nationality, dateOfBirth, contactPhone, gender, idDocument, postalAddress, subjectName, emailAddress, birthCountry);
    }

    public static InteropKycResponseData build(InteropKycData accountKyc) {
        PostalAddress postalAddress = new PostalAddress(accountKyc.getAddressLine1(), accountKyc.getAddressLine2(), accountKyc.getCity(), accountKyc.getStateProvince(), accountKyc.getPostalCode(), accountKyc.getCountry());
        IdDocument idDocument = new IdDocument(accountKyc.getIdType(), accountKyc.getIdNo(), accountKyc.getCountry(), accountKyc.getDescription());
        SubjectName subjectName = new SubjectName(accountKyc.getFirstName(), accountKyc.getMiddleName(), accountKyc.getLastName(), accountKyc.getDisplayName());
        return new InteropKycResponseData(accountKyc.getNationality(), accountKyc.getDateOfBirth(), accountKyc.getContactPhone(), accountKyc.getGender(), new IdDocument[]{idDocument}, postalAddress, subjectName, accountKyc.getEmail(), accountKyc.getCountry());
    }

    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public IdDocument[] getIdDocument() {
        return this.idDocument;
    }

    public void setIdDocument(IdDocument[] idDocument) {
        this.idDocument = idDocument;
    }

    public PostalAddress getPostalAddress() {
        return this.postalAddress;
    }

    public void setPostalAddress(PostalAddress postalAddress) {
        this.postalAddress = postalAddress;
    }

    public SubjectName getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(SubjectName subjectName) {
        this.subjectName = subjectName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getBirthCountry() {
        return this.birthCountry;
    }

    public void setBirthCountry(String birthCountry) {
        this.birthCountry = birthCountry;
    }
}

