/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.fund.service;

import jakarta.persistence.PersistenceException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.fund.domain.Fund;
import org.apache.fineract.portfolio.fund.domain.FundRepository;
import org.apache.fineract.portfolio.fund.exception.FundNotFoundException;
import org.apache.fineract.portfolio.fund.serialization.FundCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.fund.service.FundWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class FundWritePlatformServiceJpaRepositoryImpl
implements FundWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FundWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final FundCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final FundRepository fundRepository;

    @Transactional
    @CacheEvict(value={"funds"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('fn')")
    public CommandProcessingResult createFund(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            Fund fund = Fund.fromJson((JsonCommand)command);
            this.fundRepository.saveAndFlush((Object)fund);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)fund.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleFundDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleFundDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    @CacheEvict(value={"funds"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('fn')")
    public CommandProcessingResult updateFund(Long fundId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            Fund fund = (Fund)this.fundRepository.findById((Object)fundId).orElseThrow(() -> new FundNotFoundException(fundId));
            Map changes = fund.update(command);
            if (!changes.isEmpty()) {
                this.fundRepository.saveAndFlush((Object)fund);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)fund.getId()).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleFundDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleFundDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private void handleFundDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("m_fund_external_id_key")) {
            String externalId = command.stringValueOfParameterNamed("externalId");
            throw new PlatformDataIntegrityException("error.msg.fund.duplicate.externalId", "A fund with external id '" + externalId + "' already exists", "externalId", new Object[]{externalId});
        }
        if (realCause.getMessage().contains("m_fund_external_id_name")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.fund.duplicate.name", "A fund with name '" + name + "' already exists", "name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.fund.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public FundWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, FundCommandFromApiJsonDeserializer fromApiJsonDeserializer, FundRepository fundRepository) {
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.fundRepository = fundRepository;
    }
}

