/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanAdjustTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionAccrualActivityPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionAccrualActivityPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.loanaccount.data.TransactionChangeData;
import org.apache.fineract.portfolio.loanaccount.domain.ChangedTransactionDetail;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleProcessingWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelation;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelationTypeEnum;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualActivityProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanBalanceService;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LoanAccrualActivityProcessingServiceImpl
implements LoanAccrualActivityProcessingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanAccrualActivityProcessingServiceImpl.class);
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final ExternalIdFactory externalIdFactory;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanTransactionAssembler loanTransactionAssembler;
    private final LoanAccountService loanAccountService;
    private final LoanBalanceService loanBalanceService;
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanJournalEntryPoster journalEntryPoster;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void makeAccrualActivityTransaction(@NonNull Long loanId, @NonNull LocalDate currentDate) {
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        this.makeAccrualActivityTransaction(loan, currentDate);
    }

    public void makeAccrualActivityTransaction(@NonNull Loan loan, @NonNull LocalDate currentDate) {
        if (!loan.getLoanProductRelatedDetail().isEnableAccrualActivityPosting() || !loan.isOpen()) {
            return;
        }
        List installments = loan.getRepaymentScheduleInstallments(i -> !i.isDownPayment() && !DateUtils.isBefore((LocalDate)currentDate, (LocalDate)i.getDueDate()));
        if (installments.isEmpty()) {
            return;
        }
        Map existingActivitiesByDate = this.loadExistingAccrualActivitiesByDate(loan, installments);
        installments.forEach(installment -> {
            LocalDate dueDate = installment.getDueDate();
            List<LoanTransaction> existingActivities = existingActivitiesByDate.getOrDefault(dueDate, Collections.emptyList());
            boolean hasExisting = !existingActivities.isEmpty();
            LoanTransaction existingActivity = hasExisting ? (LoanTransaction)existingActivities.getFirst() : null;
            this.makeOrReplayActivity(loan, installment, existingActivity);
            if (hasExisting) {
                existingActivities.remove(existingActivity);
                existingActivities.forEach(arg_0 -> this.reverseAccrualActivityTransaction(arg_0));
            }
        });
    }

    public void recalculateAccrualActivityTransaction(Loan loan, ChangedTransactionDetail changedTransactionDetail) {
        List accrualActivities = this.loanTransactionRepository.findNonReversedByLoanAndType(loan, LoanTransactionType.ACCRUAL_ACTIVITY);
        accrualActivities.forEach(accrualActivity -> {
            LoanTransaction newLoanTransaction = LoanTransaction.copyTransactionProperties((LoanTransaction)accrualActivity);
            this.calculateAccrualActivity(newLoanTransaction, loan.getCurrency(), loan.getRepaymentScheduleInstallments());
            if (!LoanTransaction.transactionAmountsMatch((MonetaryCurrency)loan.getCurrency(), (LoanTransaction)accrualActivity, (LoanTransaction)newLoanTransaction)) {
                this.createNewTransaction(accrualActivity, newLoanTransaction, changedTransactionDetail);
            }
        });
    }

    protected void createNewTransaction(LoanTransaction loanTransaction, LoanTransaction newLoanTransaction, ChangedTransactionDetail changedTransactionDetail) {
        loanTransaction.reverse();
        if (newLoanTransaction.isNotReversed()) {
            loanTransaction.updateExternalId(null);
            newLoanTransaction.copyLoanTransactionRelations(loanTransaction.getLoanTransactionRelations());
            newLoanTransaction.getLoanTransactionRelations().add(LoanTransactionRelation.linkToTransaction((LoanTransaction)newLoanTransaction, (LoanTransaction)loanTransaction, (LoanTransactionRelationTypeEnum)LoanTransactionRelationTypeEnum.REPLAYED));
        }
        changedTransactionDetail.addTransactionChange(new TransactionChangeData(loanTransaction, newLoanTransaction));
    }

    @Transactional
    public void processAccrualActivityForLoanClosure(@NonNull Loan loan) {
        if (!loan.getLoanProductRelatedDetail().isEnableAccrualActivityPosting()) {
            return;
        }
        LocalDate closureDate = this.loanBalanceService.isOverPaid(loan) ? loan.getOverpaidOnDate() : loan.getClosedOnDate();
        this.loanTransactionRepository.findNonReversedByLoanAndTypeAndAfterDate(loan, LoanTransactionType.ACCRUAL_ACTIVITY, closureDate).forEach(arg_0 -> this.reverseAccrualActivityTransaction(arg_0));
        BigDecimal feeChargesPortion = BigDecimal.ZERO;
        BigDecimal penaltyChargesPortion = BigDecimal.ZERO;
        BigDecimal interestPortion = BigDecimal.ZERO;
        for (Object installment : loan.getRepaymentScheduleInstallments()) {
            if (installment.isDownPayment()) continue;
            feeChargesPortion = MathUtil.add((BigDecimal)feeChargesPortion, (BigDecimal)installment.getFeeChargesCharged());
            penaltyChargesPortion = MathUtil.add((BigDecimal)penaltyChargesPortion, (BigDecimal)installment.getPenaltyCharges());
            interestPortion = MathUtil.add((BigDecimal)interestPortion, (BigDecimal)installment.getInterestCharged());
        }
        List accrualActivities = this.loanTransactionRepository.findNonReversedByLoanAndType(loan, LoanTransactionType.ACCRUAL_ACTIVITY);
        for (LoanRepaymentScheduleInstallment installment : loan.getRepaymentScheduleInstallments()) {
            if (installment.isDownPayment() || installment.isAdditional() || !DateUtils.isBefore((LocalDate)installment.getDueDate(), (LocalDate)closureDate)) continue;
            List<LoanTransaction> installmentAccruals = accrualActivities.stream().filter(t -> t.getDateOf().isEqual(installment.getDueDate())).toList();
            if (installmentAccruals.isEmpty()) {
                this.makeAccrualActivityTransaction(loan, installment, installment.getDueDate());
                continue;
            }
            if (installmentAccruals.size() > 1) {
                installmentAccruals.forEach(arg_0 -> this.reverseAccrualActivityTransaction(arg_0));
                this.makeAccrualActivityTransaction(loan, installment, installment.getDueDate());
                continue;
            }
            if (this.validateActivityTransaction(installment, installmentAccruals.getFirst())) continue;
            this.reverseReplayAccrualActivityTransaction(loan, installmentAccruals.getFirst(), installment, installment.getDueDate());
        }
        accrualActivities = this.loanTransactionRepository.findNonReversedByLoanAndType(loan, LoanTransactionType.ACCRUAL_ACTIVITY);
        for (LoanTransaction accrualActivity : accrualActivities) {
            feeChargesPortion = MathUtil.subtract((BigDecimal)feeChargesPortion, (BigDecimal[])new BigDecimal[]{accrualActivity.getFeeChargesPortion()});
            penaltyChargesPortion = MathUtil.subtract((BigDecimal)penaltyChargesPortion, (BigDecimal[])new BigDecimal[]{accrualActivity.getPenaltyChargesPortion()});
            interestPortion = MathUtil.subtract((BigDecimal)interestPortion, (BigDecimal[])new BigDecimal[]{accrualActivity.getInterestPortion()});
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feeChargesPortion) || MathUtil.isGreaterThanZero((BigDecimal)penaltyChargesPortion) || MathUtil.isGreaterThanZero((BigDecimal)interestPortion)) {
            BigDecimal transactionAmount = MathUtil.add((BigDecimal[])new BigDecimal[]{feeChargesPortion, penaltyChargesPortion, interestPortion});
            LoanTransaction newActivity = new LoanTransaction(loan, loan.getOffice(), LoanTransactionType.ACCRUAL_ACTIVITY, closureDate, transactionAmount, null, interestPortion, feeChargesPortion, penaltyChargesPortion, null, false, null, this.externalIdFactory.create());
            this.makeAccrualActivityTransaction(loan, newActivity);
        }
    }

    @Transactional
    public void processAccrualActivityForLoanReopen(@NonNull Loan loan) {
        if (!loan.getLoanProductRelatedDetail().isEnableAccrualActivityPosting()) {
            return;
        }
        Optional<Object> lastAccrualActivityMarkedToReverse = this.loanTransactionRepository.findNonReversedByLoanAndType(loan, LoanTransactionType.ACCRUAL_ACTIVITY, (Pageable)PageRequest.of((int)0, (int)1)).stream().findFirst();
        Optional<LocalDate> lastAccrualActivityTransactionDate = lastAccrualActivityMarkedToReverse.map(LoanTransaction::getDateOf);
        LocalDate today = DateUtils.getBusinessLocalDate();
        List<LoanRepaymentScheduleInstallment> installments = loan.getRepaymentScheduleInstallments().stream().filter(installment -> {
            boolean isDueBefore = installment.getDueDate().isBefore(today);
            boolean isAfterOrEqualToLastAccrualDate = lastAccrualActivityTransactionDate.map(date -> DateUtils.isAfter((LocalDate)installment.getDueDate(), (LocalDate)date) || installment.getDueDate().isEqual((ChronoLocalDate)date)).orElse(true);
            return isDueBefore && isAfterOrEqualToLastAccrualDate;
        }).sorted(Comparator.comparing(LoanRepaymentScheduleInstallment::getDueDate)).toList();
        for (LoanRepaymentScheduleInstallment installment2 : installments) {
            this.makeOrReplayActivity(loan, installment2, (LoanTransaction)lastAccrualActivityMarkedToReverse.orElse(null));
            lastAccrualActivityMarkedToReverse = Optional.empty();
        }
        if (installments.isEmpty()) {
            lastAccrualActivityMarkedToReverse.ifPresent(arg_0 -> this.reverseAccrualActivityTransaction(arg_0));
        }
    }

    private void calculateAccrualActivity(LoanTransaction loanTransaction, MonetaryCurrency currency, List<LoanRepaymentScheduleInstallment> installments) {
        int firstNormalInstallmentNumber = LoanRepaymentScheduleProcessingWrapper.fetchFirstNormalInstallmentNumber(installments);
        List<LoanRepaymentScheduleInstallment> targetInstallments = installments.stream().filter(installment -> LoanRepaymentScheduleProcessingWrapper.isInPeriod((LocalDate)loanTransaction.getTransactionDate(), (LoanRepaymentScheduleInstallment)installment, (boolean)installment.getInstallmentNumber().equals(firstNormalInstallmentNumber)) || DateUtils.isEqual((LocalDate)installment.getObligationsMetOnDate(), (LocalDate)loanTransaction.getTransactionDate()) && installment.getDueDate().isAfter(loanTransaction.getTransactionDate())).toList();
        if (targetInstallments.isEmpty()) {
            return;
        }
        AtomicBoolean isReset = new AtomicBoolean(false);
        targetInstallments.forEach(currentInstallment -> {
            if (currentInstallment.isNotFullyPaidOff() && (currentInstallment.getDueDate().isAfter(loanTransaction.getTransactionDate()) || currentInstallment.getDueDate().isEqual(loanTransaction.getTransactionDate()) && loanTransaction.getTransactionDate().equals(DateUtils.getBusinessLocalDate()))) {
                loanTransaction.reverse();
            } else {
                if (!isReset.get()) {
                    loanTransaction.resetDerivedComponents();
                    isReset.set(true);
                }
                Money principalPortion = Money.zero((MonetaryCurrency)currency);
                Money interestPortion = currentInstallment.getInterestCharged(currency);
                Money feeChargesPortion = currentInstallment.getFeeChargesCharged(currency);
                Money penaltyChargesPortion = currentInstallment.getPenaltyChargesCharged(currency);
                loanTransaction.updateComponentsAndTotal(principalPortion, interestPortion, feeChargesPortion, penaltyChargesPortion);
                Loan loan = loanTransaction.getLoan();
                if ((loan.isClosedObligationsMet() || this.loanBalanceService.isOverPaid(loan)) && currentInstallment.isObligationsMet() && currentInstallment.isTransactionDateWithinPeriod(currentInstallment.getObligationsMetOnDate())) {
                    loanTransaction.updateTransactionDate(currentInstallment.getObligationsMetOnDate());
                }
            }
        });
        if (MathUtil.isZero((BigDecimal)MathUtil.nullToZero((BigDecimal)MathUtil.add((BigDecimal[])new BigDecimal[]{loanTransaction.getInterestPortion(), loanTransaction.getFeeChargesPortion(), loanTransaction.getPenaltyChargesPortion()})))) {
            loanTransaction.reverse();
        }
    }

    private Map<LocalDate, List<LoanTransaction>> loadExistingAccrualActivitiesByDate(@NonNull Loan loan, List<LoanRepaymentScheduleInstallment> installments) {
        Set dueDates = installments.stream().map(LoanRepaymentScheduleInstallment::getDueDate).collect(Collectors.toSet());
        List allActivities = this.loanTransactionRepository.findNonReversedLoanAndTypeAndDates(loan, LoanTransactionType.ACCRUAL_ACTIVITY, dueDates);
        return allActivities.stream().collect(Collectors.groupingBy(LoanTransaction::getDateOf));
    }

    private void makeOrReplayActivity(@NonNull Loan loan, @NonNull LoanRepaymentScheduleInstallment installment, LoanTransaction existingActivity) {
        LocalDate dueDate = installment.getDueDate();
        if (existingActivity == null) {
            this.makeAccrualActivityTransaction(loan, installment, dueDate);
        } else {
            this.reverseReplayAccrualActivityTransaction(loan, existingActivity, installment, dueDate);
        }
    }

    private void reverseReplayAccrualActivityTransaction(@NonNull Loan loan, @NonNull LoanTransaction loanTransaction, @NonNull LoanRepaymentScheduleInstallment installment, @NonNull LocalDate transactionDate) {
        if (this.validateActivityTransaction(installment, loanTransaction)) {
            return;
        }
        LoanTransaction newLoanTransaction = this.loanTransactionAssembler.assembleAccrualActivityTransaction(loan, installment, transactionDate);
        if (newLoanTransaction != null) {
            newLoanTransaction.copyLoanTransactionRelations(loanTransaction.getLoanTransactionRelations());
            newLoanTransaction.getLoanTransactionRelations().add(LoanTransactionRelation.linkToTransaction((LoanTransaction)newLoanTransaction, (LoanTransaction)loanTransaction, (LoanTransactionRelationTypeEnum)LoanTransactionRelationTypeEnum.REPLAYED));
            newLoanTransaction.updateExternalId(loanTransaction.getExternalId());
            loanTransaction.reverse();
            loanTransaction.updateExternalId(null);
            this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(loanTransaction);
            this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(newLoanTransaction);
            loan.addLoanTransaction(newLoanTransaction);
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(newLoanTransaction, false, false);
            LoanAdjustTransactionBusinessEvent.Data data = new LoanAdjustTransactionBusinessEvent.Data(loanTransaction);
            data.setNewTransactionDetail(newLoanTransaction);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(data));
        } else {
            this.reverseAccrualActivityTransaction(loanTransaction);
        }
    }

    private boolean validateActivityTransaction(@NonNull LoanRepaymentScheduleInstallment installment, @NonNull LoanTransaction transaction) {
        return DateUtils.isEqual((LocalDate)installment.getDueDate(), (LocalDate)transaction.getDateOf()) && MathUtil.isEqualTo((BigDecimal)transaction.getInterestPortion(), (BigDecimal)installment.getInterestCharged()) && MathUtil.isEqualTo((BigDecimal)transaction.getFeeChargesPortion(), (BigDecimal)installment.getFeeChargesCharged()) && MathUtil.isEqualTo((BigDecimal)transaction.getPenaltyChargesPortion(), (BigDecimal)installment.getPenaltyCharges());
    }

    private void reverseAccrualActivityTransaction(@NonNull LoanTransaction loanTransaction) {
        loanTransaction.reverse();
        LoanAdjustTransactionBusinessEvent.Data data = new LoanAdjustTransactionBusinessEvent.Data(loanTransaction);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(data));
    }

    private void makeAccrualActivityTransaction(@NonNull Loan loan, @NonNull LoanRepaymentScheduleInstallment installment, @NonNull LocalDate transactionDate) {
        LoanTransaction newAccrualActivityTransaction = this.loanTransactionAssembler.assembleAccrualActivityTransaction(loan, installment, transactionDate);
        if (newAccrualActivityTransaction != null) {
            LoanTransaction savedNewTransaction = this.makeAccrualActivityTransaction(loan, newAccrualActivityTransaction);
            loan.addLoanTransaction(savedNewTransaction);
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(savedNewTransaction, false, false);
        }
    }

    private LoanTransaction makeAccrualActivityTransaction(@NonNull Loan loan, @NonNull LoanTransaction newAccrualActivityTransaction) {
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanTransactionAccrualActivityPreBusinessEvent(loan));
        LoanTransaction savedNewAccrualActivityTransaction = this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(newAccrualActivityTransaction);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanTransactionAccrualActivityPostBusinessEvent(savedNewAccrualActivityTransaction));
        return savedNewAccrualActivityTransaction;
    }

    @Generated
    public LoanAccrualActivityProcessingServiceImpl(LoanRepositoryWrapper loanRepositoryWrapper, ExternalIdFactory externalIdFactory, BusinessEventNotifierService businessEventNotifierService, LoanTransactionAssembler loanTransactionAssembler, LoanAccountService loanAccountService, LoanBalanceService loanBalanceService, LoanTransactionRepository loanTransactionRepository, LoanJournalEntryPoster journalEntryPoster) {
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.externalIdFactory = externalIdFactory;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanTransactionAssembler = loanTransactionAssembler;
        this.loanAccountService = loanAccountService;
        this.loanBalanceService = loanBalanceService;
        this.loanTransactionRepository = loanTransactionRepository;
        this.journalEntryPoster = journalEntryPoster;
    }
}

