/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.transforms;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TypeInformationRawType;

@Internal
public class LegacyRawTypeTransformation
implements TypeTransformation {
    public static final TypeTransformation INSTANCE = new LegacyRawTypeTransformation();

    @Override
    public DataType transform(DataType typeToTransform) {
        LogicalType logicalType = typeToTransform.getLogicalType();
        if (logicalType instanceof LegacyTypeInformationType && logicalType.getTypeRoot() == LogicalTypeRoot.RAW) {
            TypeInformation typeInfo = ((LegacyTypeInformationType)logicalType).getTypeInformation();
            AtomicDataType rawDataType = new AtomicDataType(new TypeInformationRawType(typeInfo));
            return logicalType.isNullable() ? rawDataType : (DataType)rawDataType.notNull();
        }
        return typeToTransform;
    }
}

