/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.common;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.logical.CumulativeWindowSpec;
import org.apache.flink.table.planner.plan.logical.HoppingWindowSpec;
import org.apache.flink.table.planner.plan.logical.SessionWindowSpec;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.TumblingWindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194Q!\u0001\u0002\u0002\u0002M\u0011\u0011eQ8n[>t\u0007\u000b[=tS\u000e\fGnV5oI><H+\u00192mK\u001a+hn\u0019;j_:T!a\u0001\u0003\u0002\r\r|W.\\8o\u0015\t)a!A\u0003o_\u0012,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ii\u0011A\u0006\u0006\u0003/a\t1A]3m\u0015\tIb\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005m1\"!C*j]\u001edWMU3m\u0011!i\u0002A!A!\u0002\u0013q\u0012aB2mkN$XM\u001d\t\u0003?\u0005j\u0011\u0001\t\u0006\u0003\u000faI!A\t\u0011\u0003\u001bI+Gn\u00149u\u00072,8\u000f^3s\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001\u0003;sC&$8+\u001a;\u0011\u0005}1\u0013BA\u0014!\u0005-\u0011V\r\u001c+sC&$8+\u001a;\t\u0011%\u0002!\u0011!Q\u0001\n)\n\u0001\"\u001b8qkR\u0014V\r\u001c\t\u0003+-J!\u0001\f\f\u0003\u000fI+GNT8eK\"Aa\u0006\u0001B\u0001B\u0003%q&A\u0007pkR\u0004X\u000f\u001e*poRK\b/\u001a\t\u0003aMj\u0011!\r\u0006\u0003eY\tA\u0001^=qK&\u0011A'\r\u0002\f%\u0016dG)\u0019;b)f\u0004X\r\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u0003%9\u0018N\u001c3po&tw-F\u00019!\tID(D\u0001;\u0015\tYd!A\u0004m_\u001eL7-\u00197\n\u0005uR$A\b+j[\u0016\fE\u000f\u001e:jEV$XmV5oI><\u0018N\\4TiJ\fG/Z4z\u0011!y\u0004A!A!\u0002\u0013A\u0014AC<j]\u0012|w/\u001b8hA!)\u0011\t\u0001C\u0001\u0005\u00061A(\u001b8jiz\"baQ#G\u000f\"K\u0005C\u0001#\u0001\u001b\u0005\u0011\u0001\"B\u000fA\u0001\u0004q\u0002\"\u0002\u0013A\u0001\u0004)\u0003\"B\u0015A\u0001\u0004Q\u0003\"\u0002\u0018A\u0001\u0004y\u0003\"\u0002\u001cA\u0001\u0004A\u0004\"B&\u0001\t\u0003b\u0015!\u00043fe&4XMU8x)f\u0004X\rF\u00010\u0011\u0015q\u0005\u0001\"\u0011P\u00031)\u0007\u0010\u001d7bS:$VM]7t)\t\u00016\u000b\u0005\u0002\u0016#&\u0011!K\u0006\u0002\n%\u0016dwK]5uKJDQ\u0001V'A\u0002A\u000b!\u0001]<\t\u000bY\u0003A\u0011I,\u0002!\u0015\u001cH/[7bi\u0016\u0014vn^\"pk:$HC\u0001-_!\tIF,D\u0001[\u0015\u0005Y\u0016!B:dC2\f\u0017BA/[\u0005\u0019!u.\u001e2mK\")q,\u0016a\u0001A\u0006\u0011Q.\u001d\t\u0003C\u0012l\u0011A\u0019\u0006\u0003GZ\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0003K\n\u0014\u0001CU3m\u001b\u0016$\u0018\rZ1uCF+XM]=")
public abstract class CommonPhysicalWindowTableFunction
extends SingleRel {
    private final RelDataType outputRowType;
    private final TimeAttributeWindowingStrategy windowing;

    public TimeAttributeWindowingStrategy windowing() {
        return this.windowing;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.outputRowType;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String[] inputFieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.getInput().getRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        return super.explainTerms(pw).item("window", this.windowing().toSummaryString(inputFieldNames));
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double d;
        Double childRowCnt = mq.getRowCount(this.getInput());
        if (childRowCnt != null) {
            double d2;
            WindowSpec windowSpec = this.windowing().getWindow();
            if (windowSpec instanceof TumblingWindowSpec) {
                d2 = Predef$.MODULE$.Double2double(childRowCnt);
            } else if (windowSpec instanceof HoppingWindowSpec) {
                HoppingWindowSpec hoppingWindowSpec = (HoppingWindowSpec)windowSpec;
                int windowsNum = (int)(hoppingWindowSpec.getSize().toMillis() / hoppingWindowSpec.getSlide().toMillis());
                d2 = Predef$.MODULE$.Double2double(childRowCnt) * (double)windowsNum;
            } else if (windowSpec instanceof CumulativeWindowSpec) {
                CumulativeWindowSpec cumulativeWindowSpec = (CumulativeWindowSpec)windowSpec;
                int maxWindowsNum = (int)(cumulativeWindowSpec.getMaxSize().toMillis() / cumulativeWindowSpec.getStep().toMillis());
                d2 = Predef$.MODULE$.Double2double(childRowCnt) * (double)maxWindowsNum;
            } else if (windowSpec instanceof SessionWindowSpec) {
                SessionWindowSpec sessionWindowSpec = (SessionWindowSpec)windowSpec;
                d2 = Predef$.MODULE$.Double2double(childRowCnt) * (double)((int)sessionWindowSpec.getGap().toMillis());
            } else {
                throw new TableException(new StringBuilder(21).append("Unknown window spec: ").append(windowSpec.getClass().getSimpleName()).toString());
            }
            d = d2;
        } else {
            d = BoxesRunTime.unboxToDouble(null);
        }
        return d;
    }

    public CommonPhysicalWindowTableFunction(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RelDataType outputRowType, TimeAttributeWindowingStrategy windowing) {
        this.outputRowType = outputRowType;
        this.windowing = windowing;
        super(cluster, traitSet, inputRel);
    }
}

