/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Optional;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.serde.AggregateCallJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.AggregateCallJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ChangelogModeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ChangelogModeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ColumnJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ColumnJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ConfigurationJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ConfigurationJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ContextResolvedTableJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ContextResolvedTableJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DataTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ExecNodeGraphJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ExecNodeGraphJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.FlinkVersionJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.FlinkVersionJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalWindowJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalWindowJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RequiredDistributionJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RequiredDistributionJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedCatalogTableJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedCatalogTableJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedExpressionJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedExpressionJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedSchemaJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedSchemaJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexWindowBoundJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexWindowBoundJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.UniqueConstraintMixin;
import org.apache.flink.table.planner.plan.nodes.exec.serde.WatermarkSpecMixin;
import org.apache.flink.table.planner.plan.nodes.exec.serde.WindowReferenceJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.WindowReferenceJsonSerializer;
import org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtil;
import org.apache.flink.table.runtime.groupwindow.WindowReference;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@Internal
public class JsonSerdeUtil {
    private static final ObjectMapper OBJECT_MAPPER_INSTANCE = JacksonMapperFactory.createObjectMapper();

    public static ObjectReader createObjectReader(SerdeContext serdeContext) {
        return OBJECT_MAPPER_INSTANCE.reader().withAttribute((Object)"serdeCtx", (Object)serdeContext).with(JsonSerdeUtil.defaultInjectedValues());
    }

    public static ObjectWriter createObjectWriter(SerdeContext serdeContext) {
        return OBJECT_MAPPER_INSTANCE.writer().withAttribute((Object)"serdeCtx", (Object)serdeContext);
    }

    private static InjectableValues defaultInjectedValues() {
        return new InjectableValues.Std().addValue("isDeserialize", (Object)true);
    }

    private static Module createFlinkTableJacksonModule() {
        SimpleModule module = new SimpleModule("Flink table module");
        ExecNodeMetadataUtil.execNodes().forEach(c -> module.registerSubtypes(new NamedType[]{new NamedType(c, c.getName())}));
        JsonSerdeUtil.registerSerializers(module);
        JsonSerdeUtil.registerDeserializers(module);
        JsonSerdeUtil.registerMixins(module);
        return module;
    }

    private static void registerSerializers(SimpleModule module) {
        module.addSerializer((JsonSerializer)new ExecNodeGraphJsonSerializer());
        module.addSerializer((JsonSerializer)new FlinkVersionJsonSerializer());
        module.addSerializer((JsonSerializer)new ConfigurationJsonSerializer());
        module.addSerializer((JsonSerializer)new ObjectIdentifierJsonSerializer());
        module.addSerializer((JsonSerializer)new LogicalTypeJsonSerializer());
        module.addSerializer((JsonSerializer)new DataTypeJsonSerializer());
        module.addSerializer((JsonSerializer)new RelDataTypeJsonSerializer());
        module.addSerializer((JsonSerializer)new RexNodeJsonSerializer());
        module.addSerializer((JsonSerializer)new AggregateCallJsonSerializer());
        module.addSerializer((JsonSerializer)new ChangelogModeJsonSerializer());
        module.addSerializer((JsonSerializer)new LogicalWindowJsonSerializer());
        module.addSerializer((JsonSerializer)new RexWindowBoundJsonSerializer());
        module.addSerializer((JsonSerializer)new WindowReferenceJsonSerializer());
        module.addSerializer((JsonSerializer)new ContextResolvedTableJsonSerializer());
        module.addSerializer((JsonSerializer)new ColumnJsonSerializer());
        module.addSerializer((JsonSerializer)new ResolvedCatalogTableJsonSerializer());
        module.addSerializer((JsonSerializer)new ResolvedExpressionJsonSerializer());
        module.addSerializer((JsonSerializer)new ResolvedSchemaJsonSerializer());
        module.addSerializer((JsonSerializer)new RequiredDistributionJsonSerializer());
    }

    private static void registerDeserializers(SimpleModule module) {
        module.addDeserializer(ExecNodeGraph.class, (JsonDeserializer)new ExecNodeGraphJsonDeserializer());
        module.addDeserializer(FlinkVersion.class, (JsonDeserializer)new FlinkVersionJsonDeserializer());
        module.addDeserializer(ReadableConfig.class, (JsonDeserializer)new ConfigurationJsonDeserializer());
        module.addDeserializer(ObjectIdentifier.class, (JsonDeserializer)new ObjectIdentifierJsonDeserializer());
        module.addDeserializer(LogicalType.class, (JsonDeserializer)new LogicalTypeJsonDeserializer());
        module.addDeserializer(RowType.class, (JsonDeserializer)new LogicalTypeJsonDeserializer());
        module.addDeserializer(DataType.class, (JsonDeserializer)new DataTypeJsonDeserializer());
        module.addDeserializer(RelDataType.class, (JsonDeserializer)new RelDataTypeJsonDeserializer());
        module.addDeserializer(RexNode.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        module.addDeserializer(RexLiteral.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        module.addDeserializer(AggregateCall.class, (JsonDeserializer)new AggregateCallJsonDeserializer());
        module.addDeserializer(ChangelogMode.class, (JsonDeserializer)new ChangelogModeJsonDeserializer());
        module.addDeserializer(LogicalWindow.class, (JsonDeserializer)new LogicalWindowJsonDeserializer());
        module.addDeserializer(RexWindowBound.class, (JsonDeserializer)new RexWindowBoundJsonDeserializer());
        module.addDeserializer(WindowReference.class, (JsonDeserializer)new WindowReferenceJsonDeserializer());
        module.addDeserializer(ContextResolvedTable.class, (JsonDeserializer)new ContextResolvedTableJsonDeserializer());
        module.addDeserializer(Column.class, (JsonDeserializer)new ColumnJsonDeserializer());
        module.addDeserializer(ResolvedCatalogTable.class, (JsonDeserializer)new ResolvedCatalogTableJsonDeserializer());
        module.addDeserializer(ResolvedExpression.class, (JsonDeserializer)new ResolvedExpressionJsonDeserializer());
        module.addDeserializer(ResolvedSchema.class, (JsonDeserializer)new ResolvedSchemaJsonDeserializer());
        module.addDeserializer(InputProperty.RequiredDistribution.class, (JsonDeserializer)new RequiredDistributionJsonDeserializer());
    }

    private static void registerMixins(SimpleModule module) {
        module.setMixInAnnotation(WatermarkSpec.class, WatermarkSpecMixin.class);
        module.setMixInAnnotation(UniqueConstraint.class, UniqueConstraintMixin.class);
    }

    static JsonParser traverse(TreeNode node, ObjectCodec objectCodec) throws IOException {
        JsonParser jsonParser = node.traverse(objectCodec);
        if (!node.isMissingNode() && jsonParser.getCurrentToken() == null) {
            jsonParser.nextToken();
        }
        return jsonParser;
    }

    static void serializeOptionalField(JsonGenerator jsonGenerator, String fieldName, Optional<?> value, SerializerProvider serializerProvider) throws IOException {
        if (value.isPresent()) {
            serializerProvider.defaultSerializeField(fieldName, value.get(), jsonGenerator);
        }
    }

    static <T> Optional<T> deserializeOptionalField(ObjectNode objectNode, String fieldName, Class<T> clazz, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        if (objectNode.hasNonNull(fieldName)) {
            return Optional.ofNullable(ctx.readValue(JsonSerdeUtil.traverse((TreeNode)objectNode.get(fieldName), codec), clazz));
        }
        return Optional.empty();
    }

    static <T> Optional<T> deserializeOptionalField(ObjectNode objectNode, String fieldName, JavaType type, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        if (objectNode.hasNonNull(fieldName)) {
            return Optional.of(ctx.readValue(JsonSerdeUtil.traverse((TreeNode)objectNode.get(fieldName), codec), type));
        }
        return Optional.empty();
    }

    static Class<?> loadClass(String className, SerdeContext serdeContext, String explanation) {
        try {
            return ExtractionUtils.classForName((String)className, (boolean)true, (ClassLoader)serdeContext.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new TableException(String.format("Could not load class '%s' for %s.", className, explanation), (Throwable)e);
        }
    }

    private JsonSerdeUtil() {
    }

    static {
        OBJECT_MAPPER_INSTANCE.setTypeFactory(OBJECT_MAPPER_INSTANCE.getTypeFactory().withClassLoader(JsonSerdeUtil.class.getClassLoader()));
        OBJECT_MAPPER_INSTANCE.configure(MapperFeature.USE_GETTERS_AS_SETTERS, false);
        OBJECT_MAPPER_INSTANCE.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        OBJECT_MAPPER_INSTANCE.registerModule(JsonSerdeUtil.createFlinkTableJacksonModule());
    }
}

