/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.apache.calcite.avatica.util.Source;

public abstract class Sources {
    private Sources() {
    }

    public static Source of(File file) {
        return new FileSource(file);
    }

    public static Source of(URL url) {
        return new FileSource(url);
    }

    public static Source file(File baseDirectory, String fileName) {
        File file = new File(fileName);
        if (baseDirectory != null && !file.isAbsolute()) {
            return Sources.of(new File(baseDirectory, fileName));
        }
        return Sources.of(file);
    }

    public static Source url(String url) {
        try {
            return Sources.of(new URL(url));
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new RuntimeException("Malformed URL: '" + url + "'", e);
        }
    }

    private static String trimOrNull(String s2, String suffix) {
        return s2.endsWith(suffix) ? s2.substring(0, s2.length() - suffix.length()) : null;
    }

    private static boolean isFile(Source source) {
        return source.protocol().equals("file");
    }

    private static class FileSource
    implements Source {
        private final File file;
        private final URL url;
        private final boolean urlGenerated;

        private FileSource(URL url) {
            this.url = Objects.requireNonNull(url, "url");
            this.file = FileSource.urlToFile(url);
            this.urlGenerated = false;
        }

        private FileSource(File file) {
            this.file = Objects.requireNonNull(file, "file");
            this.url = FileSource.fileToUrl(file);
            this.urlGenerated = true;
        }

        private File fileNonNull() {
            return Objects.requireNonNull(this.file, "file");
        }

        private static File urlToFile(URL url) {
            URI uri;
            if (!"file".equals(url.getProtocol())) {
                return null;
            }
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert URL " + url + " to URI", e);
            }
            if (uri.isOpaque()) {
                return new File(uri.getSchemeSpecificPart());
            }
            return Paths.get(uri).toFile();
        }

        private static URL fileToUrl(File file) {
            String filePath = file.getPath();
            if (!file.isAbsolute()) {
                filePath = filePath.replace(File.separatorChar, '/');
                if (file.isDirectory() && !filePath.endsWith("/")) {
                    filePath = filePath + "/";
                }
                try {
                    String encodedPath = new URI(null, null, filePath, null).getRawPath();
                    return new URL("file", null, 0, encodedPath);
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new IllegalArgumentException("Unable to create URL for file " + filePath, e);
                }
            }
            URI uri = null;
            try {
                uri = file.toURI();
                return uri.toURL();
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("No access to the underlying file " + filePath, e);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Unable to convert URI " + uri + " to URL", e);
            }
        }

        public String toString() {
            return (this.urlGenerated ? this.fileNonNull() : this.url).toString();
        }

        @Override
        public URL url() {
            return this.url;
        }

        @Override
        public File file() {
            if (this.file == null) {
                throw new UnsupportedOperationException();
            }
            return this.file;
        }

        @Override
        public String protocol() {
            return this.file != null ? "file" : this.url.getProtocol();
        }

        @Override
        public String path() {
            if (this.file != null) {
                return this.file.getPath();
            }
            try {
                return this.url.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert URL " + this.url + " to URI", e);
            }
        }

        @Override
        public Reader reader() throws IOException {
            InputStream is;
            if (this.path().endsWith(".gz")) {
                InputStream fis = this.openStream();
                is = new GZIPInputStream(fis);
            } else {
                is = this.openStream();
            }
            return new InputStreamReader(is, StandardCharsets.UTF_8);
        }

        @Override
        public InputStream openStream() throws IOException {
            if (this.file != null) {
                return new FileInputStream(this.file);
            }
            return this.url.openStream();
        }

        @Override
        public Source trim(String suffix) {
            Source x = this.trimOrNull(suffix);
            return x == null ? this : x;
        }

        @Override
        public Source trimOrNull(String suffix) {
            if (!this.urlGenerated) {
                String s2 = Sources.trimOrNull(this.url.toExternalForm(), suffix);
                return s2 == null ? null : Sources.url(s2);
            }
            String s3 = Sources.trimOrNull(this.fileNonNull().getPath(), suffix);
            return s3 == null ? null : Sources.of(new File(s3));
        }

        @Override
        public Source append(Source child) {
            if (Sources.isFile(child)) {
                if (child.file().isAbsolute()) {
                    return child;
                }
            } else {
                try {
                    URI uri = child.url().toURI();
                    if (!uri.isOpaque()) {
                        return child;
                    }
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Unable to convert URL " + child.url() + " to URI", e);
                }
            }
            String path = child.path();
            if (!this.urlGenerated) {
                String encodedPath = new File(".").toURI().relativize(new File(path).toURI()).getRawSchemeSpecificPart();
                return Sources.url(this.url + "/" + encodedPath);
            }
            return Sources.file(this.file, path);
        }

        @Override
        public Source relative(Source parent) {
            String rest;
            if (Sources.isFile(parent)) {
                String rest2;
                if (Sources.isFile(this) && this.fileNonNull().getPath().startsWith(parent.file().getPath()) && (rest2 = this.fileNonNull().getPath().substring(parent.file().getPath().length())).startsWith(File.separator)) {
                    return Sources.file(null, rest2.substring(File.separator.length()));
                }
                return this;
            }
            if (!Sources.isFile(this) && (rest = Sources.trimOrNull(this.url.toExternalForm(), parent.url().toExternalForm())) != null && rest.startsWith("/")) {
                return Sources.file(null, rest.substring(1));
            }
            return this;
        }
    }
}

