/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.BearerTokenCredentials;
import com.aliyuncs.auth.BearerTokenSigner;
import com.aliyuncs.auth.HmacSHA1Signer;
import com.aliyuncs.auth.KeyPairCredentials;
import com.aliyuncs.auth.SHA256withRSASigner;

public abstract class Signer {
    private static final Signer HMACSHA1_SIGNER = new HmacSHA1Signer();
    private static final Signer SHA256_WITH_RSA_SIGNER = new SHA256withRSASigner();
    private static final Signer BEARER_TOKEN_SIGNER = new BearerTokenSigner();

    public static Signer getSigner(AlibabaCloudCredentials credentials) {
        if (credentials instanceof KeyPairCredentials) {
            return SHA256_WITH_RSA_SIGNER;
        }
        if (credentials instanceof BearerTokenCredentials) {
            return BEARER_TOKEN_SIGNER;
        }
        return HMACSHA1_SIGNER;
    }

    public abstract String signString(String var1, AlibabaCloudCredentials var2);

    public abstract String signString(String var1, String var2);

    public abstract String getSignerName();

    public abstract String getSignerVersion();

    public abstract String getSignerType();
}

