/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.state.api.BootstrapTransformation;
import org.apache.flink.state.api.SavepointWriterOperatorFactory;
import org.apache.flink.state.api.functions.Timestamper;
import org.apache.flink.state.api.output.operators.StateBootstrapWrapperOperator;
import org.apache.flink.streaming.api.functions.windowing.PassThroughWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperatorBuilder;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class WindowedOperatorTransformation<T, K, W extends Window> {
    private final DataSet<T> input;
    private final WindowOperatorBuilder<T, K, W> builder;
    private final long checkpointId;
    private final OptionalInt operatorMaxParallelism;
    @Nullable
    private final Timestamper<T> timestamper;
    private final KeySelector<T, K> keySelector;
    private final TypeInformation<K> keyType;

    WindowedOperatorTransformation(DataSet<T> input, long checkpointId, OptionalInt operatorMaxParallelism, @Nullable Timestamper<T> timestamper, KeySelector<T, K> keySelector, TypeInformation<K> keyType, WindowAssigner<? super T, W> windowAssigner) {
        this.input = input;
        this.checkpointId = checkpointId;
        this.operatorMaxParallelism = operatorMaxParallelism;
        this.timestamper = timestamper;
        this.keySelector = keySelector;
        this.keyType = keyType;
        this.builder = new WindowOperatorBuilder(windowAssigner, windowAssigner.getDefaultTrigger(), input.getExecutionEnvironment().getConfig(), input.getType(), keySelector, keyType);
    }

    @PublicEvolving
    public WindowedOperatorTransformation<T, K, W> trigger(Trigger<? super T, ? super W> trigger) {
        this.builder.trigger(trigger);
        return this;
    }

    @PublicEvolving
    public WindowedOperatorTransformation<T, K, W> evictor(Evictor<? super T, ? super W> evictor) {
        this.builder.evictor(evictor);
        return this;
    }

    public BootstrapTransformation<T> reduce(ReduceFunction<T> function) {
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of reduce can not be a RichFunction. Please use reduce(ReduceFunction, WindowFunction) instead.");
        }
        function = (ReduceFunction)this.input.clean(function);
        return this.reduce((ReduceFunction<T>)function, (WindowFunction)new PassThroughWindowFunction());
    }

    public <R> BootstrapTransformation<T> reduce(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function) {
        function = (WindowFunction)this.input.clean(function);
        reduceFunction = (ReduceFunction)this.input.clean(reduceFunction);
        WindowOperator operator = this.builder.reduce(reduceFunction, function);
        SavepointWriterOperatorFactory factory = (timestamp, path) -> new StateBootstrapWrapperOperator(this.checkpointId, timestamp, path, operator);
        return new BootstrapTransformation<T>(this.input, this.operatorMaxParallelism, this.timestamper, factory, this.keySelector, this.keyType);
    }

    @Internal
    public <R> BootstrapTransformation<T> reduce(ReduceFunction<T> reduceFunction, ProcessWindowFunction<T, R, K, W> function) {
        function = (ProcessWindowFunction)this.input.clean(function);
        reduceFunction = (ReduceFunction)this.input.clean(reduceFunction);
        WindowOperator operator = this.builder.reduce(reduceFunction, function);
        SavepointWriterOperatorFactory factory = (timestamp, path) -> new StateBootstrapWrapperOperator(this.checkpointId, timestamp, path, operator);
        return new BootstrapTransformation<T>(this.input, this.operatorMaxParallelism, this.timestamper, factory, this.keySelector, this.keyType);
    }

    @PublicEvolving
    public <ACC, R> BootstrapTransformation<T> aggregate(AggregateFunction<T, ACC, R> function) {
        Preconditions.checkNotNull(function, (String)"function");
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregation function cannot be a RichFunction.");
        }
        TypeInformation accumulatorType = TypeExtractor.getAggregateFunctionAccumulatorType(function, (TypeInformation)this.input.getType(), null, (boolean)false);
        return this.aggregate(function, accumulatorType);
    }

    @PublicEvolving
    public <ACC, R> BootstrapTransformation<T> aggregate(AggregateFunction<T, ACC, R> function, TypeInformation<ACC> accumulatorType) {
        Preconditions.checkNotNull(function, (String)"function");
        Preconditions.checkNotNull(accumulatorType, (String)"accumulatorType");
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregation function cannot be a RichFunction.");
        }
        return this.aggregate((AggregateFunction)function, (WindowFunction)new PassThroughWindowFunction(), accumulatorType);
    }

    @PublicEvolving
    public <ACC, V, R> BootstrapTransformation<T> aggregate(AggregateFunction<T, ACC, V> aggFunction, WindowFunction<V, R, K, W> windowFunction) {
        Preconditions.checkNotNull(aggFunction, (String)"aggFunction");
        Preconditions.checkNotNull(windowFunction, (String)"windowFunction");
        TypeInformation accumulatorType = TypeExtractor.getAggregateFunctionAccumulatorType(aggFunction, (TypeInformation)this.input.getType(), null, (boolean)false);
        return this.aggregate(aggFunction, windowFunction, accumulatorType);
    }

    @PublicEvolving
    public <ACC, V, R> BootstrapTransformation<T> aggregate(AggregateFunction<T, ACC, V> aggregateFunction, WindowFunction<V, R, K, W> windowFunction, TypeInformation<ACC> accumulatorType) {
        Preconditions.checkNotNull(aggregateFunction, (String)"aggregateFunction");
        Preconditions.checkNotNull(windowFunction, (String)"windowFunction");
        Preconditions.checkNotNull(accumulatorType, (String)"accumulatorType");
        if (aggregateFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregate function cannot be a RichFunction.");
        }
        windowFunction = (WindowFunction)this.input.clean(windowFunction);
        aggregateFunction = (AggregateFunction)this.input.clean(aggregateFunction);
        WindowOperator operator = this.builder.aggregate(aggregateFunction, windowFunction, accumulatorType);
        SavepointWriterOperatorFactory factory = (timestamp, path) -> new StateBootstrapWrapperOperator(this.checkpointId, timestamp, path, operator);
        return new BootstrapTransformation<T>(this.input, this.operatorMaxParallelism, this.timestamper, factory, this.keySelector, this.keyType);
    }

    @PublicEvolving
    public <ACC, V, R> BootstrapTransformation<T> aggregate(AggregateFunction<T, ACC, V> aggFunction, ProcessWindowFunction<V, R, K, W> windowFunction) {
        Preconditions.checkNotNull(aggFunction, (String)"aggFunction");
        Preconditions.checkNotNull(windowFunction, (String)"windowFunction");
        TypeInformation accumulatorType = TypeExtractor.getAggregateFunctionAccumulatorType(aggFunction, (TypeInformation)this.input.getType(), null, (boolean)false);
        return this.aggregate(aggFunction, windowFunction, accumulatorType);
    }

    @PublicEvolving
    public <ACC, V, R> BootstrapTransformation<T> aggregate(AggregateFunction<T, ACC, V> aggregateFunction, ProcessWindowFunction<V, R, K, W> windowFunction, TypeInformation<ACC> accumulatorType) {
        Preconditions.checkNotNull(aggregateFunction, (String)"aggregateFunction");
        Preconditions.checkNotNull(windowFunction, (String)"windowFunction");
        Preconditions.checkNotNull(accumulatorType, (String)"accumulatorType");
        if (aggregateFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregate function cannot be a RichFunction.");
        }
        windowFunction = (ProcessWindowFunction)this.input.clean(windowFunction);
        aggregateFunction = (AggregateFunction)this.input.clean(aggregateFunction);
        WindowOperator operator = this.builder.aggregate(aggregateFunction, windowFunction, accumulatorType);
        SavepointWriterOperatorFactory factory = (timestamp, path) -> new StateBootstrapWrapperOperator(this.checkpointId, timestamp, path, operator);
        return new BootstrapTransformation<T>(this.input, this.operatorMaxParallelism, this.timestamper, factory, this.keySelector, this.keyType);
    }

    public <R> BootstrapTransformation<T> apply(WindowFunction<T, R, K, W> function) {
        WindowOperator operator = this.builder.apply(function);
        SavepointWriterOperatorFactory factory = (timestamp, path) -> new StateBootstrapWrapperOperator(this.checkpointId, timestamp, path, operator);
        return new BootstrapTransformation<T>(this.input, this.operatorMaxParallelism, this.timestamper, factory, this.keySelector, this.keyType);
    }

    public <R> BootstrapTransformation<T> apply(WindowFunction<T, R, K, W> function, TypeInformation<R> resultType) {
        function = (WindowFunction)this.input.clean(function);
        WindowOperator operator = this.builder.apply(function);
        SavepointWriterOperatorFactory factory = (timestamp, path) -> new StateBootstrapWrapperOperator(this.checkpointId, timestamp, path, operator);
        return new BootstrapTransformation<T>(this.input, this.operatorMaxParallelism, this.timestamper, factory, this.keySelector, this.keyType);
    }

    @PublicEvolving
    public <R> BootstrapTransformation<T> process(ProcessWindowFunction<T, R, K, W> function) {
        WindowOperator operator = this.builder.process(function);
        SavepointWriterOperatorFactory factory = (timestamp, path) -> new StateBootstrapWrapperOperator(this.checkpointId, timestamp, path, operator);
        return new BootstrapTransformation<T>(this.input, this.operatorMaxParallelism, this.timestamper, factory, this.keySelector, this.keyType);
    }
}

