/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.util.Preconditions;

@Internal
class DefaultCatalogView
implements CatalogView {
    private final Schema schema;
    @Nullable
    private final String comment;
    private final String originalQuery;
    private final String expandedQuery;
    private final Map<String, String> options;

    DefaultCatalogView(Schema schema, @Nullable String comment, String originalQuery, String expandedQuery, Map<String, String> options) {
        this.schema = (Schema)Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        this.comment = comment;
        this.originalQuery = (String)Preconditions.checkNotNull((Object)originalQuery, (String)"Original query must not be null.");
        this.expandedQuery = (String)Preconditions.checkNotNull((Object)expandedQuery, (String)"Expanded query must not be null.");
        this.options = (Map)Preconditions.checkNotNull(options, (String)"Options must not be null.");
        Preconditions.checkArgument((boolean)options.entrySet().stream().allMatch(e -> e.getKey() != null && e.getValue() != null), (Object)"Options cannot have null keys or values.");
    }

    @Override
    public Schema getUnresolvedSchema() {
        return this.schema;
    }

    @Override
    public String getComment() {
        return this.comment != null ? this.comment : "";
    }

    @Override
    public String getOriginalQuery() {
        return this.originalQuery;
    }

    @Override
    public String getExpandedQuery() {
        return this.expandedQuery;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public CatalogBaseTable copy() {
        return new DefaultCatalogView(this.schema, this.comment, this.originalQuery, this.expandedQuery, this.options);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.of(this.getComment());
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCatalogView that = (DefaultCatalogView)o;
        return this.schema.equals(that.schema) && Objects.equals(this.comment, that.comment) && this.originalQuery.equals(that.originalQuery) && this.expandedQuery.equals(that.expandedQuery) && this.options.equals(that.options);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.comment, this.originalQuery, this.expandedQuery, this.options);
    }
}

