/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public class RowtimeTypeStrategy
implements TypeStrategy {
    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        DataType dataType = callContext.getArgumentDataTypes().get(0);
        LogicalType inputType = dataType.getLogicalType();
        if (inputType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) || inputType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return Optional.of(dataType);
        }
        if (inputType.is(LogicalTypeRoot.BIGINT)) {
            DataType timestampType = DataTypes.TIMESTAMP(3);
            if (dataType.getLogicalType().isNullable()) {
                return Optional.of(timestampType.nullable());
            }
            return Optional.of(timestampType.notNull());
        }
        return Optional.empty();
    }
}

