/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.ServiceSignature;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.SignParameters;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class SignUtils {
    public static String composeRequestAuthorization(String accessKeyId, String signature) {
        return "OSS " + accessKeyId + ":" + signature;
    }

    public static String buildCanonicalString(String method, String resourcePath, RequestMessage request, String expires) {
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(method).append("\n");
        Map<String, String> headers = request.getHeaders();
        TreeMap<String, String> headersToSign = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String lowerKey;
                if (entry.getKey() == null || !(lowerKey = entry.getKey().toLowerCase()).equals("Content-Type".toLowerCase()) && !lowerKey.equals("Content-MD5".toLowerCase()) && !lowerKey.equals("Date".toLowerCase()) && !lowerKey.startsWith("x-oss-")) continue;
                headersToSign.put(lowerKey, entry.getValue().trim());
            }
        }
        if (!headersToSign.containsKey("Content-Type".toLowerCase())) {
            headersToSign.put("Content-Type".toLowerCase(), "");
        }
        if (!headersToSign.containsKey("Content-MD5".toLowerCase())) {
            headersToSign.put("Content-MD5".toLowerCase(), "");
        }
        for (Map.Entry<String, String> entry : headersToSign.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith("x-oss-")) {
                canonicalString.append(key).append(':').append((Object)value);
            } else {
                canonicalString.append((Object)value);
            }
            canonicalString.append("\n");
        }
        canonicalString.append(SignUtils.buildCanonicalizedResource(resourcePath, request.getParameters()));
        return canonicalString.toString();
    }

    public static String buildRtmpCanonicalString(String canonicalizedResource, RequestMessage request, String expires) {
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(expires + "\n");
        for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            canonicalString.append(key).append(':').append(value);
            canonicalString.append("\n");
        }
        canonicalString.append(canonicalizedResource);
        return canonicalString.toString();
    }

    public static String buildSignedURL(GeneratePresignedUrlRequest request, Credentials currentCreds, ClientConfiguration config, URI endpoint) {
        String bucketName = request.getBucketName();
        String accessId = currentCreds.getAccessKeyId();
        String accessKey = currentCreds.getSecretAccessKey();
        boolean useSecurityToken = currentCreds.useSecurityToken();
        HttpMethod method = request.getMethod() != null ? request.getMethod() : HttpMethod.GET;
        String expires = String.valueOf(request.getExpiration().getTime() / 1000L);
        String key = request.getKey();
        String resourcePath = OSSUtils.determineResourcePath(bucketName, key, config.isSLDEnabled());
        RequestMessage requestMessage = new RequestMessage(bucketName, key);
        requestMessage.setEndpoint(OSSUtils.determineFinalEndpoint(endpoint, bucketName, config));
        requestMessage.setMethod(method);
        requestMessage.setResourcePath(resourcePath);
        requestMessage.setHeaders(request.getHeaders());
        requestMessage.addHeader("Date", expires);
        if (request.getContentType() != null && !request.getContentType().trim().equals("")) {
            requestMessage.addHeader("Content-Type", request.getContentType());
        }
        if (request.getContentMD5() != null && !request.getContentMD5().trim().equals("")) {
            requestMessage.addHeader("Content-MD5", request.getContentMD5());
        }
        for (Map.Entry<String, String> h2 : request.getUserMetadata().entrySet()) {
            requestMessage.addHeader("x-oss-meta-" + h2.getKey(), h2.getValue());
        }
        HashMap<String, String> responseHeaderParams = new HashMap<String, String>();
        OSSUtils.populateResponseHeaderParameters(responseHeaderParams, request.getResponseHeaders());
        SignUtils.populateTrafficLimitParams(responseHeaderParams, request.getTrafficLimit());
        if (responseHeaderParams.size() > 0) {
            requestMessage.setParameters(responseHeaderParams);
        }
        if (request.getQueryParameter() != null && request.getQueryParameter().size() > 0) {
            for (Map.Entry<String, String> entry : request.getQueryParameter().entrySet()) {
                requestMessage.addParameter(entry.getKey(), entry.getValue());
            }
        }
        if (request.getProcess() != null && !request.getProcess().trim().equals("")) {
            requestMessage.addParameter("x-oss-process", request.getProcess());
        }
        if (useSecurityToken) {
            requestMessage.addParameter("security-token", currentCreds.getSecurityToken());
        }
        String canonicalResource = "/" + (bucketName != null ? bucketName : "") + (key != null ? "/" + key : "");
        String canonicalString = SignUtils.buildCanonicalString(method.toString(), canonicalResource, requestMessage, expires);
        String signature = ServiceSignature.create().computeSignature(accessKey, canonicalString);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("Expires", expires);
        params.put("OSSAccessKeyId", accessId);
        params.put("Signature", signature);
        params.putAll(requestMessage.getParameters());
        String queryString = HttpUtil.paramToQueryString(params, "utf-8");
        String url = requestMessage.getEndpoint().toString();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + resourcePath + "?" + queryString;
        return url;
    }

    public static String buildCanonicalizedResource(String resourcePath, Map<String, String> parameters) {
        CodingUtils.assertTrue(resourcePath.startsWith("/"), "Resource path should start with slash character");
        StringBuilder builder = new StringBuilder();
        builder.append(resourcePath);
        if (parameters != null) {
            Object[] parameterNames = parameters.keySet().toArray(new String[parameters.size()]);
            Arrays.sort(parameterNames);
            int separator = 63;
            for (Object paramName : parameterNames) {
                if (!SignParameters.SIGNED_PARAMTERS.contains(paramName)) continue;
                builder.append((char)separator);
                builder.append((String)paramName);
                String paramValue = parameters.get(paramName);
                if (paramValue != null) {
                    builder.append("=").append(paramValue);
                }
                separator = 38;
            }
        }
        return builder.toString();
    }

    public static String buildSignature(String secretAccessKey, String httpMethod, String resourcePath, RequestMessage request) {
        String canonicalString = SignUtils.buildCanonicalString(httpMethod, resourcePath, request, null);
        return ServiceSignature.create().computeSignature(secretAccessKey, canonicalString);
    }

    private static void populateTrafficLimitParams(Map<String, String> params, int limit) {
        if (limit > 0) {
            params.put("x-oss-traffic-limit", String.valueOf(limit));
        }
    }
}

