/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.table.planner.functions.sql.SqlDefaultOperator;

public class FlinkSqlCallBinding
extends SqlCallBinding {
    private final List<RelDataType> fixArgumentTypes = this.getFixArgumentTypes();
    private final List<SqlNode> rewrittenOperands = this.getRewrittenOperands();

    public FlinkSqlCallBinding(SqlValidator validator, @Nullable SqlValidatorScope scope, SqlCall call) {
        super(validator, scope, call);
    }

    @Override
    public int getOperandCount() {
        return this.rewrittenOperands.size();
    }

    @Override
    public List<SqlNode> operands() {
        if (this.isFixedParameters()) {
            return this.rewrittenOperands;
        }
        return super.operands();
    }

    @Override
    public RelDataType getOperandType(int ordinal) {
        if (!this.isFixedParameters()) {
            return super.getOperandType(ordinal);
        }
        SqlNode operand = this.rewrittenOperands.get(ordinal);
        if (operand.getKind() == SqlKind.DEFAULT) {
            return this.fixArgumentTypes.get(ordinal);
        }
        RelDataType type = SqlTypeUtil.deriveType((SqlCallBinding)this, operand);
        SqlValidatorNamespace namespace = this.getValidator().getNamespace(operand);
        return namespace != null ? namespace.getType() : type;
    }

    public boolean isFixedParameters() {
        return !this.fixArgumentTypes.isEmpty();
    }

    private List<RelDataType> getFixArgumentTypes() {
        SqlOperandTypeChecker sqlOperandTypeChecker = this.getOperator().getOperandTypeChecker();
        if (sqlOperandTypeChecker instanceof SqlOperandMetadata && sqlOperandTypeChecker.isFixedParameters()) {
            return ((SqlOperandMetadata)sqlOperandTypeChecker).paramTypes(this.getTypeFactory());
        }
        return Collections.emptyList();
    }

    private List<SqlNode> getRewrittenOperands() {
        if (!this.isFixedParameters()) {
            return super.operands();
        }
        ArrayList<SqlNode> rewrittenOperands = new ArrayList<SqlNode>();
        for (SqlNode operand : super.operands()) {
            if (operand instanceof SqlCall && ((SqlCall)operand).getOperator() == SqlStdOperatorTable.DEFAULT) {
                rewrittenOperands.add(new SqlDefaultOperator(this.fixArgumentTypes.get(rewrittenOperands.size())).createCall(SqlParserPos.ZERO, new SqlNode[0]));
                continue;
            }
            rewrittenOperands.add(operand);
        }
        return rewrittenOperands;
    }
}

