/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.ZoneId;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.guava32.com.google.common.collect.Lists;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.WindowAttachedWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.window.WindowJoinOperator;
import org.apache.flink.table.runtime.operators.join.window.WindowJoinOperatorBuilder;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-window-join", version=1, consumedOptions={"table.local-time-zone"}, producedTransformations={"window-join"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecWindowJoin
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String WINDOW_JOIN_TRANSFORMATION = "window-join";
    public static final String FIELD_NAME_JOIN_SPEC = "joinSpec";
    public static final String FIELD_NAME_LEFT_WINDOWING = "leftWindowing";
    public static final String FIELD_NAME_RIGHT_WINDOWING = "rightWindowing";
    @JsonProperty(value="joinSpec")
    private final JoinSpec joinSpec;
    @JsonProperty(value="leftWindowing")
    private final WindowingStrategy leftWindowing;
    @JsonProperty(value="rightWindowing")
    private final WindowingStrategy rightWindowing;

    public StreamExecWindowJoin(ReadableConfig tableConfig, JoinSpec joinSpec, WindowingStrategy leftWindowing, WindowingStrategy rightWindowing, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecWindowJoin.class), ExecNodeContext.newPersistedConfig(StreamExecWindowJoin.class, tableConfig), joinSpec, leftWindowing, rightWindowing, Lists.newArrayList((Object[])new InputProperty[]{leftInputProperty, rightInputProperty}), outputType, description);
    }

    @JsonCreator
    public StreamExecWindowJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="joinSpec") JoinSpec joinSpec, @JsonProperty(value="leftWindowing") WindowingStrategy leftWindowing, @JsonProperty(value="rightWindowing") WindowingStrategy rightWindowing, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 2 ? 1 : 0) != 0);
        this.joinSpec = (JoinSpec)Preconditions.checkNotNull((Object)joinSpec);
        this.validate(leftWindowing);
        this.validate(rightWindowing);
        this.leftWindowing = leftWindowing;
        this.rightWindowing = rightWindowing;
    }

    private void validate(WindowingStrategy windowing) {
        if (!windowing.isRowtime()) {
            throw new TableException("Processing time Window Join is not supported yet.");
        }
        if (!(windowing instanceof WindowAttachedWindowingStrategy)) {
            throw new TableException(windowing.getClass().getName() + " is not supported yet.");
        }
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        int leftWindowEndIndex = ((WindowAttachedWindowingStrategy)this.leftWindowing).getWindowEnd();
        int rightWindowEndIndex = ((WindowAttachedWindowingStrategy)this.rightWindowing).getWindowEnd();
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        Transformation<?> leftTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightTransform = rightInputEdge.translateToPlan(planner);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        JoinUtil.validateJoinSpec(this.joinSpec, leftType, rightType, true);
        int[] leftJoinKey = this.joinSpec.getLeftKeys();
        int[] rightJoinKey = this.joinSpec.getRightKeys();
        InternalTypeInfo leftTypeInfo = InternalTypeInfo.of((RowType)leftType);
        InternalTypeInfo rightTypeInfo = InternalTypeInfo.of((RowType)rightType);
        GeneratedJoinCondition generatedCondition = JoinUtil.generateConditionFunction((ReadableConfig)config, planner.getFlinkContext().getClassLoader(), this.joinSpec, (LogicalType)leftType, (LogicalType)rightType);
        ZoneId shiftTimeZone = TimeWindowUtil.getShiftTimeZone((LogicalType)this.leftWindowing.getTimeAttributeType(), (ZoneId)TableConfigUtils.getLocalTimeZone(config));
        WindowJoinOperator operator = WindowJoinOperatorBuilder.builder().leftSerializer((TypeSerializer)leftTypeInfo.toRowSerializer()).rightSerializer((TypeSerializer)rightTypeInfo.toRowSerializer()).generatedJoinCondition(generatedCondition).leftWindowEndIndex(leftWindowEndIndex).rightWindowEndIndex(rightWindowEndIndex).filterNullKeys(this.joinSpec.getFilterNulls()).joinType(this.joinSpec.getJoinType()).withShiftTimezone(shiftTimeZone).build();
        RowType returnType = (RowType)this.getOutputType();
        TwoInputTransformation transform = ExecNodeUtil.createTwoInputTransformation(leftTransform, rightTransform, this.createTransformationMeta(WINDOW_JOIN_TRANSFORMATION, config), operator, InternalTypeInfo.of((RowType)returnType), leftTransform.getParallelism(), false);
        RowDataKeySelector leftSelect = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), leftJoinKey, (InternalTypeInfo<RowData>)leftTypeInfo);
        RowDataKeySelector rightSelect = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), rightJoinKey, (InternalTypeInfo<RowData>)rightTypeInfo);
        transform.setStateKeySelectors((KeySelector)leftSelect, (KeySelector)rightSelect);
        transform.setStateKeyType((TypeInformation)leftSelect.getProducedType());
        return transform;
    }
}

