/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.writer;

import java.util.List;
import java.util.UUID;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.gs.storage.GSBlobIdentifier;
import org.apache.flink.fs.gs.writer.GSCommitRecoverable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GSResumeRecoverable
extends GSCommitRecoverable
implements RecoverableWriter.ResumeRecoverable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSResumeRecoverable.class);
    public final long position;
    public final boolean closed;

    GSResumeRecoverable(GSBlobIdentifier finalBlobIdentifier, List<UUID> componentObjectIds, long position, boolean closed) {
        super(finalBlobIdentifier, componentObjectIds);
        LOGGER.trace("Creating GSResumeRecoverable for blob {} with position={}, closed={}, and componentObjectIds={}", new Object[]{finalBlobIdentifier, position, closed, componentObjectIds});
        Preconditions.checkArgument((position >= 0L ? 1 : 0) != 0);
        this.position = position;
        this.closed = closed;
    }

    @Override
    public String toString() {
        return "GSResumeRecoverable{finalBlobIdentifier=" + this.finalBlobIdentifier + ", componentObjectIds=" + this.componentObjectIds + ", position=" + this.position + ", closed=" + this.closed + "}";
    }
}

