/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelWriterOutputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.HeaderlessChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.table.runtime.io.ChannelWithMeta;
import org.apache.flink.table.runtime.io.CompressedBlockChannelReader;
import org.apache.flink.table.runtime.io.CompressedBlockChannelWriter;
import org.apache.flink.table.runtime.io.CompressedHeaderlessChannelReaderInputView;
import org.apache.flink.table.runtime.io.CompressedHeaderlessChannelWriterOutputView;
import org.apache.flink.table.runtime.io.HeaderlessChannelWriterOutputView;

public class FileChannelUtil {
    public static AbstractChannelReaderInputView createInputView(IOManager ioManager, ChannelWithMeta channel, List<FileIOChannel> channels, boolean compressionEnabled, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize, int segmentSize) throws IOException {
        if (compressionEnabled) {
            CompressedHeaderlessChannelReaderInputView in = new CompressedHeaderlessChannelReaderInputView(channel.getChannel(), ioManager, compressionCodecFactory, compressionBlockSize, channel.getBlockCount());
            channels.add((FileIOChannel)in.getReader());
            return in;
        }
        BlockChannelReader reader = ioManager.createBlockChannelReader(channel.getChannel());
        channels.add((FileIOChannel)reader);
        return new HeaderlessChannelReaderInputView(reader, Arrays.asList(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize), MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize)), channel.getBlockCount(), channel.getNumBytesInLastBlock(), false);
    }

    public static AbstractChannelWriterOutputView createOutputView(IOManager ioManager, FileIOChannel.ID channel, boolean compressionEnabled, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize, int segmentSize) throws IOException {
        if (compressionEnabled) {
            BufferFileWriter bufferWriter = ioManager.createBufferFileWriter(channel);
            return new CompressedHeaderlessChannelWriterOutputView(bufferWriter, compressionCodecFactory, compressionBlockSize);
        }
        BlockChannelWriter blockWriter = ioManager.createBlockChannelWriter(channel);
        return new HeaderlessChannelWriterOutputView((BlockChannelWriter<MemorySegment>)blockWriter, Arrays.asList(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize), MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize)), segmentSize);
    }

    public static BlockChannelWriter<MemorySegment> createBlockChannelWriter(IOManager ioManager, FileIOChannel.ID channel, LinkedBlockingQueue<MemorySegment> bufferReturnQueue, boolean compressionEnable, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize, int segmentSize) throws IOException {
        if (compressionEnable) {
            return new CompressedBlockChannelWriter(ioManager, channel, bufferReturnQueue, compressionCodecFactory, compressionBlockSize, segmentSize);
        }
        return ioManager.createBlockChannelWriter(channel, bufferReturnQueue);
    }

    public static BlockChannelReader<MemorySegment> createBlockChannelReader(IOManager ioManager, FileIOChannel.ID channel, LinkedBlockingQueue<MemorySegment> bufferReturnQueue, boolean compressionEnable, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize, int segmentSize) throws IOException {
        if (compressionEnable) {
            return new CompressedBlockChannelReader(ioManager, channel, bufferReturnQueue, compressionCodecFactory, compressionBlockSize, segmentSize);
        }
        return ioManager.createBlockChannelReader(channel, bufferReturnQueue);
    }
}

