/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.mysql;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.CharType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.VarcharType;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLExternalDataType;
import org.apache.gravitino.trino.connector.util.GeneralDataTypeTransformer;
import org.apache.gravitino.trino.connector.util.json.JsonCodec;

public class MySQLDataTypeTransformer
extends GeneralDataTypeTransformer {
    private static final int MYSQL_CHAR_LENGTH_LIMIT = 255;
    private static final int MYSQL_VARCHAR_LENGTH_LIMIT = 16383;
    public static final io.trino.spi.type.Type JSON_TYPE = JsonCodec.getJsonType(MySQLDataTypeTransformer.class.getClassLoader());

    @Override
    public io.trino.spi.type.Type getTrinoType(Type type) {
        if (type.name() == Type.Name.STRING) {
            return VarcharType.createUnboundedVarcharType();
        }
        if (Type.Name.TIMESTAMP == type.name()) {
            Types.TimestampType timestampType = (Types.TimestampType)type;
            if (timestampType.hasTimeZone()) {
                return TimestampWithTimeZoneType.TIMESTAMP_TZ_SECONDS;
            }
            return TimestampType.TIMESTAMP_SECONDS;
        }
        if (Type.Name.TIME == type.name()) {
            return TimeType.TIME_SECONDS;
        }
        if (Type.Name.EXTERNAL == type.name()) {
            String catalogString = ((Types.ExternalType)type).catalogString();
            return MySQLExternalDataType.safeValueOf(catalogString).getTrinoType();
        }
        return super.getTrinoType(type);
    }

    @Override
    public Type getGravitinoType(io.trino.spi.type.Type type) {
        Class<?> typeClass = type.getClass();
        if (typeClass == CharType.class) {
            CharType charType = (CharType)type;
            if (charType.getLength() > 255) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "MySQL does not support the datatype CHAR with the length greater than 255");
            }
            if (charType.getLength() == 0) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "MySQL does not support the datatype CHAR with the length 0");
            }
            return Types.FixedCharType.of((int)charType.getLength());
        }
        if (typeClass == VarcharType.class) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.getLength().isEmpty()) {
                return Types.StringType.get();
            }
            int length = (Integer)varcharType.getLength().get();
            if (length > 16383) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "MySQL does not support the datatype VARCHAR with the length greater than 16383");
            }
            return Types.VarCharType.of((int)length);
        }
        if (typeClass == JSON_TYPE.getClass()) {
            return Types.ExternalType.of((String)MySQLExternalDataType.JSON.getMysqlTypeName());
        }
        if (TimeType.class.isAssignableFrom(typeClass)) {
            return Types.TimeType.of((int)0);
        }
        if (TimestampType.class.isAssignableFrom(typeClass)) {
            return Types.TimestampType.withoutTimeZone((int)0);
        }
        if (TimestampWithTimeZoneType.class.isAssignableFrom(typeClass)) {
            return Types.TimestampType.withTimeZone((int)0);
        }
        return super.getGravitinoType(type);
    }
}

