/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.mysql;

import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLDataTypeTransformer;

public enum MySQLExternalDataType {
    MEDIUMINT("mediumint", (Type)IntegerType.INTEGER),
    MEDIUMINT_UNSIGNED("mediumint unsigned", (Type)IntegerType.INTEGER),
    FLOAT_UNSIGNED("float unsigned", (Type)RealType.REAL),
    DOUBLE_UNSIGNED("double unsigned", (Type)DoubleType.DOUBLE),
    TINYTEXT("tinytext", (Type)VarcharType.VARCHAR),
    MEDIUMTEXT("mediumtext", (Type)VarcharType.VARCHAR),
    LONGTEXT("longtext", (Type)VarcharType.VARCHAR),
    YEAR("year", (Type)DateType.DATE),
    ENUM("enum", (Type)VarcharType.VARCHAR),
    SET("set", (Type)VarcharType.VARCHAR),
    JSON("json", MySQLDataTypeTransformer.JSON_TYPE),
    VARBINARY("varbinary", (Type)VarbinaryType.VARBINARY),
    TINYBLOB("tinyblob", (Type)VarbinaryType.VARBINARY),
    BLOB("blob", (Type)VarbinaryType.VARBINARY),
    MEDIUMBLOB("mediumblob", (Type)VarbinaryType.VARBINARY),
    LONGBLOB("longblob", (Type)VarbinaryType.VARBINARY),
    GEOMETRY("geometry", (Type)VarbinaryType.VARBINARY),
    UNKNOWN("unknown", (Type)VarcharType.VARCHAR);

    private final String mysqlTypeName;
    private final Type trinoType;

    private MySQLExternalDataType(String mysqlTypeName, Type trinoType) {
        this.mysqlTypeName = mysqlTypeName;
        this.trinoType = trinoType;
    }

    public String getMysqlTypeName() {
        return this.mysqlTypeName;
    }

    public Type getTrinoType() {
        return this.trinoType;
    }

    public static MySQLExternalDataType safeValueOf(String mysqlTypeName) {
        for (MySQLExternalDataType mySQLExternalDataType : MySQLExternalDataType.values()) {
            if (!mySQLExternalDataType.mysqlTypeName.equalsIgnoreCase(mysqlTypeName)) continue;
            return mySQLExternalDataType;
        }
        return UNKNOWN;
    }
}

