/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.mysql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.session.PropertyMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.catalog.property.PropertyConverter;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.jdbc.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLDataTypeTransformer;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLPropertyMeta;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLTablePropertyConverter;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MysqlColumnDefaultValueConverter;
import org.apache.gravitino.trino.connector.metadata.GravitinoColumn;
import org.apache.gravitino.trino.connector.metadata.GravitinoTable;
import org.apache.logging.log4j.util.Strings;

public class MySQLMetadataAdapter
extends CatalogConnectorMetadataAdapter {
    private final PropertyConverter tableConverter = new MySQLTablePropertyConverter();
    private final JdbcColumnDefaultValueConverter columnDefaultValueConverter = new MysqlColumnDefaultValueConverter();

    public MySQLMetadataAdapter(List<PropertyMetadata<?>> schemaProperties, List<PropertyMetadata<?>> tableProperties, List<PropertyMetadata<?>> columnProperties) {
        super(schemaProperties, tableProperties, columnProperties, new MySQLDataTypeTransformer());
    }

    @Override
    public Map<String, String> toGravitinoTableProperties(Map<String, Object> properties) {
        Map stringMap = this.tableConverter.engineToGravitinoProperties(properties);
        return super.toGravitinoTableProperties(stringMap);
    }

    @Override
    public Map<String, Object> toTrinoTableProperties(Map<String, String> properties) {
        Map objectMap = this.tableConverter.gravitinoToEngineProperties(properties);
        return super.toTrinoTableProperties(objectMap);
    }

    @Override
    public GravitinoTable createTable(ConnectorTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableSchema().getTable().getTableName();
        String schemaName = tableMetadata.getTableSchema().getTable().getSchemaName();
        String comment = tableMetadata.getComment().orElse("");
        Map tableProperties = tableMetadata.getProperties();
        Map<String, String> properties = this.toGravitinoTableProperties(tableProperties);
        Set<String> primaryKeyList = MySQLPropertyMeta.getPrimaryKey(tableProperties);
        Map<String, Set<String>> uniqueKeyMap = MySQLPropertyMeta.getUniqueKey(tableProperties);
        ArrayList<GravitinoColumn> columns = new ArrayList<GravitinoColumn>();
        ImmutableList.Builder incrementColumnListBuilder = ImmutableList.builder();
        ImmutableSet.Builder columnNamesBuilder = ImmutableSet.builder();
        for (int i = 0; i < tableMetadata.getColumns().size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableMetadata.getColumns().get(i);
            if (primaryKeyList.contains(column.getName()) && column.isNullable()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Primary key must be NOT NULL in MySQL");
            }
            Map columnProperties = column.getProperties();
            boolean autoIncrement = MySQLPropertyMeta.isAutoIncrement(columnProperties);
            String defaultValue = MySQLPropertyMeta.getDefaultValue(columnProperties);
            Type gravitinoType = this.dataTypeTransformer.getGravitinoType(column.getType());
            GravitinoColumn gravitinoColumn = new GravitinoColumn(column.getName(), gravitinoType, i, column.getComment(), column.isNullable(), autoIncrement, this.columnDefaultValueConverter.toGravitino(gravitinoType, defaultValue, column.isNullable()), MySQLPropertyMeta.filterColumnProperties(columnProperties));
            columns.add(gravitinoColumn);
            if (autoIncrement) {
                incrementColumnListBuilder.add((Object)gravitinoColumn);
            }
            columnNamesBuilder.add((Object)column.getName());
        }
        Index[] indexes = MySQLMetadataAdapter.buildIndexes(primaryKeyList, uniqueKeyMap, (Set<String>)columnNamesBuilder.build());
        MySQLMetadataAdapter.validateIncrementCol((List<GravitinoColumn>)incrementColumnListBuilder.build(), indexes);
        return new GravitinoTable(schemaName, tableName, columns, comment, properties, indexes);
    }

    private static Index[] buildIndexes(Set<String> primaryKeyList, Map<String, Set<String>> uniqueKeyMap, Set<String> columnNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!primaryKeyList.isEmpty()) {
            builder.add((Object)MySQLMetadataAdapter.convertPrimaryKey(primaryKeyList, columnNames));
        }
        if (!uniqueKeyMap.isEmpty()) {
            builder.addAll(MySQLMetadataAdapter.convertUniqueKey(uniqueKeyMap, columnNames));
        }
        ImmutableList indexList = builder.build();
        return indexList.toArray(new Index[indexList.size()]);
    }

    private static Index convertPrimaryKey(Set<String> primaryKeys, Set<String> columnNames) {
        for (String primaryKeyColumn : primaryKeys) {
            if (columnNames.contains(primaryKeyColumn)) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Column '%s' specified in property '%s' doesn't exist in table", primaryKeyColumn, "primary_key"));
        }
        return Indexes.createMysqlPrimaryKey((String[][])MySQLMetadataAdapter.convertIndexFieldNames(primaryKeys));
    }

    private static List<Index> convertUniqueKey(Map<String, Set<String>> uniqueKeys, Set<String> columnNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String uniqueKey : uniqueKeys.keySet()) {
            Set<String> uniqueKeyColumns = uniqueKeys.get(uniqueKey);
            for (String uniqueKeyColumn : uniqueKeyColumns) {
                if (columnNames.contains(uniqueKeyColumn)) continue;
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Column '%s' specified in property '%s' doesn't exist in table", uniqueKeyColumn, "unique_key"));
            }
            builder.add((Object)Indexes.unique((String)uniqueKey, (String[][])MySQLMetadataAdapter.convertIndexFieldNames(uniqueKeyColumns)));
        }
        return builder.build();
    }

    /*
     * Exception decompiling
     */
    private static String[][] convertIndexFieldNames(Set<String> fieldNames) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void validateIncrementCol(List<GravitinoColumn> columns, Index[] indexes) {
        if (columns.size() > 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Only one column can be auto-incremented in MySQL");
        }
        if (!columns.isEmpty()) {
            GravitinoColumn incrementColumn = columns.get(0);
            if (!(incrementColumn.getType() instanceof Type.IntegralType)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Auto increment column must be integer type in MySQL");
            }
            if (incrementColumn.isNullable()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Auto increment column must be not null in MySQL");
            }
            if (Column.DEFAULT_VALUE_NOT_SET != incrementColumn.getDefaultValue()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Auto increment column cannot have a default value in MySQL");
            }
            String colName = incrementColumn.getName();
            Optional<Index> existAutoIncrementColIndexOptional = Arrays.stream(indexes).filter(index -> Arrays.stream(index.fieldNames()).flatMap(Arrays::stream).anyMatch(s -> StringUtils.equalsIgnoreCase((CharSequence)colName, (CharSequence)s))).filter(index -> index.type() == Index.IndexType.PRIMARY_KEY || index.type() == Index.IndexType.UNIQUE_KEY).findAny();
            if (!existAutoIncrementColIndexOptional.isPresent()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Auto increment column must be defined as a key in MySQL");
            }
        }
    }

    @Override
    public ConnectorTableMetadata getTableMetadata(GravitinoTable gravitinoTable) {
        SchemaTableName schemaTableName = new SchemaTableName(gravitinoTable.getSchemaName(), gravitinoTable.getName());
        ArrayList<ColumnMetadata> columnMetadataList = new ArrayList<ColumnMetadata>();
        for (GravitinoColumn column : gravitinoTable.getColumns()) {
            columnMetadataList.add(this.getColumnMetadata(column));
        }
        Map<String, Object> properties = this.toTrinoTableProperties(gravitinoTable.getProperties());
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        propertiesBuilder.putAll(properties);
        Object[] indexes = gravitinoTable.getIndexes();
        if (ArrayUtils.isNotEmpty((Object[])indexes)) {
            ArrayList primaryKeys = new ArrayList();
            ArrayList<String> uniqueKeys = new ArrayList<String>();
            block5: for (int i = 0; i < indexes.length; ++i) {
                Object index = indexes[i];
                switch (index.type()) {
                    case PRIMARY_KEY: {
                        Arrays.stream(index.fieldNames()).flatMap(Arrays::stream).forEach(col -> primaryKeys.add(col));
                        continue block5;
                    }
                    case UNIQUE_KEY: {
                        List columns = Arrays.stream(index.fieldNames()).flatMap(Arrays::stream).collect(Collectors.toUnmodifiableList());
                        uniqueKeys.add(String.format("%s:%s", index.name(), Strings.join(columns, (char)',')));
                        continue block5;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported index type: " + String.valueOf(index.type()));
                    }
                }
            }
            if (!primaryKeys.isEmpty()) {
                propertiesBuilder.put((Object)"primary_key", primaryKeys);
            }
            if (!uniqueKeys.isEmpty()) {
                propertiesBuilder.put((Object)"unique_key", uniqueKeys);
            }
        }
        return new ConnectorTableMetadata(schemaTableName, columnMetadataList, (Map)propertiesBuilder.build(), Optional.ofNullable(gravitinoTable.getComment()));
    }

    @Override
    public ColumnMetadata getColumnMetadata(GravitinoColumn column) {
        String defaultValue;
        HashMap propertyMap = Maps.newHashMap(column.getProperties());
        if (column.isAutoIncrement()) {
            propertyMap.put("auto_increment", true);
        }
        if ((defaultValue = this.columnDefaultValueConverter.fromGravitino(column.getDefaultValue())) != null) {
            propertyMap.put("default", defaultValue);
        }
        return ColumnMetadata.builder().setName(column.getName()).setType(this.dataTypeTransformer.getTrinoType(column.getType())).setComment(Optional.ofNullable(column.getComment())).setNullable(column.isNullable()).setHidden(column.isHidden()).setProperties((Map)propertyMap).build();
    }

    private static /* synthetic */ String[][] lambda$convertIndexFieldNames$1(int x$0) {
        return new String[x$0][];
    }
}

