/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.system.storedprocedure;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.procedure.Procedure;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorManager;
import org.apache.gravitino.trino.connector.system.storedprocedure.AlterCatalogStoredProcedure;
import org.apache.gravitino.trino.connector.system.storedprocedure.CreateCatalogStoredProcedure;
import org.apache.gravitino.trino.connector.system.storedprocedure.DropCatalogStoredProcedure;
import org.apache.gravitino.trino.connector.system.storedprocedure.GravitinoStoredProcedure;

public class GravitinoStoredProcedureFactory {
    private final CatalogConnectorManager catalogConnectorManager;
    private final String metalake;
    public final List<GravitinoStoredProcedure> procedures = new ArrayList<GravitinoStoredProcedure>();

    public GravitinoStoredProcedureFactory(CatalogConnectorManager catalogConnectorManager, String metalake) {
        this.catalogConnectorManager = catalogConnectorManager;
        this.metalake = metalake;
        this.registerStoredProcedure();
    }

    private void registerStoredProcedure() {
        this.procedures.add(new CreateCatalogStoredProcedure(this.catalogConnectorManager, this.metalake));
        this.procedures.add(new DropCatalogStoredProcedure(this.catalogConnectorManager, this.metalake));
        this.procedures.add(new AlterCatalogStoredProcedure(this.catalogConnectorManager, this.metalake));
    }

    public Set<Procedure> getStoredProcedures() {
        return this.procedures.stream().map(v -> {
            try {
                return v.createStoredProcedure();
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_OPERATION, "Failed to initialize Gravitino system procedures", (Throwable)e);
            }
        }).collect(Collectors.toSet());
    }
}

