/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.client.IntervalYearMonth;
import java.util.Objects;

public class TrinoIntervalYearMonth
implements Comparable<TrinoIntervalYearMonth> {
    private final int months;

    public TrinoIntervalYearMonth(int months) {
        this.months = months;
    }

    public TrinoIntervalYearMonth(int year, int months) {
        this.months = IntervalYearMonth.toMonths(year, months);
    }

    public int getMonths() {
        return this.months;
    }

    public int hashCode() {
        return Objects.hash(this.months);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoIntervalYearMonth other = (TrinoIntervalYearMonth)obj;
        return this.months == other.months;
    }

    @Override
    public int compareTo(TrinoIntervalYearMonth o) {
        return Integer.compare(this.months, o.months);
    }

    public String toString() {
        return IntervalYearMonth.formatMonths(this.months);
    }
}

