/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BufferedMutatorExample
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(BufferedMutatorExample.class);
    private static final int POOL_SIZE = 10;
    private static final int TASK_COUNT = 100;
    private static final TableName TABLE = TableName.valueOf((String)"foo");
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");

    public int run(String[] args) throws InterruptedException, ExecutionException, TimeoutException {
        BufferedMutator.ExceptionListener listener = new BufferedMutator.ExceptionListener(){

            public void onException(RetriesExhaustedWithDetailsException e, BufferedMutator mutator) {
                for (int i = 0; i < e.getNumExceptions(); ++i) {
                    LOG.info("Failed to sent put " + e.getRow(i) + ".");
                }
            }
        };
        BufferedMutatorParams params = new BufferedMutatorParams(TABLE).listener(listener);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());
             final BufferedMutator mutator = conn.getBufferedMutator(params);){
            ExecutorService workerPool = Executors.newFixedThreadPool(10);
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(100);
            for (int i = 0; i < 100; ++i) {
                futures.add(workerPool.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Put p = new Put(Bytes.toBytes((String)"someRow"));
                        p.addColumn(FAMILY, Bytes.toBytes((String)"someQualifier"), Bytes.toBytes((String)"some value"));
                        mutator.mutate((Mutation)p);
                        return null;
                    }
                }));
            }
            for (Future future : futures) {
                future.get(5L, TimeUnit.MINUTES);
            }
            workerPool.shutdown();
        }
        catch (IOException e) {
            LOG.info("exception while creating/destroying Connection or BufferedMutator", (Throwable)e);
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new BufferedMutatorExample(), (String[])args);
    }
}

