/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestPutDeleteEtcCellIteration {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPutDeleteEtcCellIteration.class);
    private static final byte[] ROW = new byte[]{114};
    private static final long TIMESTAMP = EnvironmentEdgeManager.currentTime();
    private static final int COUNT = 10;

    @Test
    public void testPutIteration() throws IOException {
        Put p = new Put(ROW);
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            p.addColumn(bytes, bytes, TIMESTAMP, bytes);
        }
        int index = 0;
        CellScanner cellScanner = p.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] bytes = Bytes.toBytes((int)index++);
            Assert.assertEquals((Object)new KeyValue(ROW, bytes, bytes, TIMESTAMP, bytes), (Object)cell);
        }
        Assert.assertEquals((long)10L, (long)index);
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testPutConcurrentModificationOnIteration() throws IOException {
        Put p = new Put(ROW);
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            p.addColumn(bytes, bytes, TIMESTAMP, bytes);
        }
        int index = 0;
        CellScanner cellScanner = p.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] bytes = Bytes.toBytes((int)index++);
            p.addColumn(bytes, bytes, TIMESTAMP, bytes);
            Assert.assertEquals((Object)new KeyValue(ROW, bytes, bytes, TIMESTAMP, bytes), (Object)cell);
        }
    }

    @Test
    public void testDeleteIteration() throws IOException {
        Delete d = new Delete(ROW);
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            d.addColumn(bytes, bytes, TIMESTAMP);
        }
        int index = 0;
        CellScanner cellScanner = d.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] bytes = Bytes.toBytes((int)index++);
            Assert.assertEquals((Object)new KeyValue(ROW, bytes, bytes, TIMESTAMP, KeyValue.Type.Delete), (Object)cell);
        }
        Assert.assertEquals((long)10L, (long)index);
    }

    @Test
    public void testAppendIteration() throws IOException {
        Append a = new Append(ROW);
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            a.addColumn(bytes, bytes, bytes);
        }
        int index = 0;
        CellScanner cellScanner = a.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] bytes = Bytes.toBytes((int)index++);
            KeyValue kv = (KeyValue)cell;
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneFamily((Cell)kv), (byte[])bytes));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)kv), (byte[])bytes));
        }
        Assert.assertEquals((long)10L, (long)index);
    }

    @Test
    public void testIncrementIteration() throws IOException {
        Increment increment = new Increment(ROW);
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            increment.addColumn(bytes, bytes, (long)i);
        }
        int index = 0;
        CellScanner cellScanner = increment.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            int value = index;
            byte[] bytes = Bytes.toBytes((int)index++);
            KeyValue kv = (KeyValue)cell;
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneFamily((Cell)kv), (byte[])bytes));
            long a = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kv));
            Assert.assertEquals((long)value, (long)a);
        }
        Assert.assertEquals((long)10L, (long)index);
    }

    @Test
    public void testResultIteration() throws IOException {
        Cell[] cells = new Cell[10];
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            cells[i] = new KeyValue(ROW, bytes, bytes, TIMESTAMP, bytes);
        }
        Result r = Result.create(Arrays.asList(cells));
        int index = 0;
        CellScanner cellScanner = r.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] bytes = Bytes.toBytes((int)index++);
            Assert.assertEquals((Object)new KeyValue(ROW, bytes, bytes, TIMESTAMP, bytes), (Object)cell);
        }
        Assert.assertEquals((long)10L, (long)index);
    }
}

