/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileListFile;
import org.apache.hadoop.hbase.shaded.protobuf.generated.StoreFileTrackerProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.io.ByteStreams;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestStoreFileListFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStoreFileListFile.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestStoreFileListFile.class);
    private static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();
    private Path testDir;
    private StoreFileListFile storeFileListFile;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws IOException {
        this.testDir = UTIL.getDataTestDir(this.name.getMethodName());
        HRegionFileSystem hfs = (HRegionFileSystem)Mockito.mock(HRegionFileSystem.class);
        Mockito.when((Object)hfs.getFileSystem()).thenReturn((Object)FileSystem.get((Configuration)UTIL.getConfiguration()));
        StoreContext ctx = StoreContext.getBuilder().withFamilyStoreDirectoryPath(this.testDir).withRegionFileSystem(hfs).build();
        this.storeFileListFile = new StoreFileListFile(ctx);
    }

    @AfterClass
    public static void tearDown() {
        UTIL.cleanupTestDir();
    }

    @Test
    public void testEmptyLoad() throws IOException {
        Assert.assertNull((Object)this.storeFileListFile.load());
    }

    private FileStatus getOnlyTrackerFile(FileSystem fs) throws IOException {
        return fs.listStatus(new Path(this.testDir, ".filelist"))[0];
    }

    private byte[] readAll(FileSystem fs, Path file) throws IOException {
        try (FSDataInputStream in = fs.open(file);){
            byte[] byArray = ByteStreams.toByteArray((InputStream)in);
            return byArray;
        }
    }

    private void write(FileSystem fs, Path file, byte[] buf, int off, int len) throws IOException {
        try (FSDataOutputStream out = fs.create(file, true);){
            out.write(buf, off, len);
        }
    }

    @Test
    public void testLoadPartial() throws IOException {
        StoreFileTrackerProtos.StoreFileList.Builder builder = StoreFileTrackerProtos.StoreFileList.newBuilder();
        this.storeFileListFile.update(builder);
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FileStatus trackerFileStatus = this.getOnlyTrackerFile(fs);
        LOG.info("Truncate file {} with size {} to {}", new Object[]{trackerFileStatus.getPath(), trackerFileStatus.getLen(), trackerFileStatus.getLen() / 2L});
        byte[] content = this.readAll(fs, trackerFileStatus.getPath());
        this.write(fs, trackerFileStatus.getPath(), content, 0, content.length / 2);
        Assert.assertNull((Object)this.storeFileListFile.load());
    }

    private void writeInt(byte[] buf, int off, int value) {
        byte[] b = Bytes.toBytes((int)value);
        for (int i = 0; i < 4; ++i) {
            buf[off + i] = b[i];
        }
    }

    @Test
    public void testZeroFileLength() throws IOException {
        StoreFileTrackerProtos.StoreFileList.Builder builder = StoreFileTrackerProtos.StoreFileList.newBuilder();
        this.storeFileListFile.update(builder);
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FileStatus trackerFileStatus = this.getOnlyTrackerFile(fs);
        byte[] content = this.readAll(fs, trackerFileStatus.getPath());
        this.writeInt(content, 0, 0);
        this.write(fs, trackerFileStatus.getPath(), content, 0, content.length);
        Assert.assertThrows(IOException.class, () -> this.storeFileListFile.load());
    }

    @Test
    public void testBigFileLength() throws IOException {
        StoreFileTrackerProtos.StoreFileList.Builder builder = StoreFileTrackerProtos.StoreFileList.newBuilder();
        this.storeFileListFile.update(builder);
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FileStatus trackerFileStatus = this.getOnlyTrackerFile(fs);
        byte[] content = this.readAll(fs, trackerFileStatus.getPath());
        this.writeInt(content, 0, 0x8000000);
        this.write(fs, trackerFileStatus.getPath(), content, 0, content.length);
        Assert.assertThrows(IOException.class, () -> this.storeFileListFile.load());
    }

    @Test
    public void testChecksumMismatch() throws IOException {
        StoreFileTrackerProtos.StoreFileList.Builder builder = StoreFileTrackerProtos.StoreFileList.newBuilder();
        this.storeFileListFile.update(builder);
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FileStatus trackerFileStatus = this.getOnlyTrackerFile(fs);
        byte[] content = this.readAll(fs, trackerFileStatus.getPath());
        content[5] = ~content[5];
        this.write(fs, trackerFileStatus.getPath(), content, 0, content.length);
        Assert.assertThrows(IOException.class, () -> this.storeFileListFile.load());
    }

    @Test
    public void testLoadHigherVersion() throws IOException {
        StoreFileTrackerProtos.StoreFileList storeFileList = StoreFileTrackerProtos.StoreFileList.newBuilder().setVersion(2L).setTimestamp(EnvironmentEdgeManager.currentTime()).build();
        Path trackFileDir = new Path(this.testDir, ".filelist");
        StoreFileListFile.write((FileSystem)FileSystem.get((Configuration)UTIL.getConfiguration()), (Path)new Path(trackFileDir, "f1"), (StoreFileTrackerProtos.StoreFileList)storeFileList);
        IOException error = (IOException)Assert.assertThrows(IOException.class, () -> this.storeFileListFile.load());
        Assert.assertEquals((Object)"Higher store file list version detected, expected 1, got 2", (Object)error.getMessage());
    }
}

