/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core.ranges;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.LongContent;
import com.google.uzaygezen.core.Pow2LengthBitSetRange;
import com.google.uzaygezen.core.ranges.LongRange;
import com.google.uzaygezen.core.ranges.RangeHome;
import java.util.List;

public enum LongRangeHome implements RangeHome<Long, LongContent, LongRange>
{
    INSTANCE;


    @Override
    public LongRange of(Long start, Long end) {
        return LongRange.of(start, end);
    }

    @Override
    public LongRange toRange(Pow2LengthBitSetRange bitSetRange) {
        long inclusiveStart = bitSetRange.getStart().toExactLong();
        long delta = 1L << bitSetRange.getLevel();
        Preconditions.checkArgument((bitSetRange.getLevel() <= 62 ? 1 : 0) != 0, (String)"bitSetRange=%s exceeds 62 bits for a non-negative long.", (Object[])new Object[]{bitSetRange});
        long exclusiveEnd = inclusiveStart + delta;
        return LongRange.of(inclusiveStart, exclusiveEnd);
    }

    @Override
    public LongContent overlap(List<LongRange> x, List<LongRange> y) {
        long overlap = LongRange.overlap(x, y);
        return new LongContent(overlap);
    }
}

