/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetRank", value="_FUNC_(sketch, [inclusive,] value)", extended=" Returns a normalized rank of a given value from a given KllFloatsSketch. The optional boolean parameter inclusive (default: true) determines if the weight of the given value is included in the rank or not. The returned rank is an approximation to the fraction of values of the distribution that are less than the given value (mass of the distribution below the given value).")
public class GetRankUDF
extends UDF {
    public Double evaluate(BytesWritable serializedSketch, float value) {
        return this.evaluate(serializedSketch, true, value);
    }

    public Double evaluate(BytesWritable serializedSketch, Boolean inclusive, float value) {
        if (serializedSketch == null) {
            return null;
        }
        KllFloatsSketch sketch = KllFloatsSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        if (sketch.isEmpty()) {
            return null;
        }
        return sketch.getRank(value, inclusive != false ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
    }
}

