/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.serde2.AbstractEncodingAwareSerDe;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParametersImpl;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@SerDeSpec(schemaProps={"columns", "columns.types", "field.delim", "collection.delim", "mapkey.delim", "serialization.format", "serialization.null.format", "serialization.escape.crlf", "serialization.last.column.takes.rest", "escape.delim", "serialization.encoding", "hive.serialization.extend.nesting.levels", "hive.serialization.extend.additional.nesting.levels"})
@InterfaceAudience.Public
@InterfaceStability.Stable
public class LazySimpleSerDe
extends AbstractEncodingAwareSerDe {
    private LazySerDeParameters serdeParams = null;
    private ObjectInspector cachedObjectInspector;
    private long serializedSize;
    private SerDeStats stats;
    private boolean lastOperationSerialize;
    private boolean lastOperationDeserialize;
    LazyStruct cachedLazyStruct;
    ByteArrayRef byteArrayRef;
    Text serializeCache = new Text();
    ByteStream.Output serializeStream = new ByteStream.Output();

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(String.valueOf(this.getClass()) + " [serdeParams=" + String.valueOf(this.serdeParams) + ", cachedObjectInspector=" + String.valueOf(this.cachedObjectInspector) + ", serializedSize=" + this.serializedSize + ", stats=" + String.valueOf(this.stats) + ", lastOperationSerialize=" + this.lastOperationSerialize + ", lastOperationDeserialize=" + this.lastOperationDeserialize);
        if (this.serdeParams != null) {
            sb.append(' ').append(Arrays.toString(this.serdeParams.getSeparators()));
            if (this.serdeParams.getRowTypeInfo() != null) {
                sb.append(" : ");
                sb.append(((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames());
                sb.append(" : ");
                sb.append(((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldTypeInfos());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        this.serdeParams = new LazySerDeParameters(configuration, this.properties, this.getClass().getName());
        this.cachedObjectInspector = LazyFactory.createLazyStructInspector(this.serdeParams.getColumnNames(), this.serdeParams.getColumnTypes(), new LazyObjectInspectorParametersImpl(this.serdeParams));
        this.cachedLazyStruct = (LazyStruct)LazyFactory.createLazyObject(this.cachedObjectInspector);
        this.serializedSize = 0L;
        this.stats = new SerDeStats();
        this.lastOperationSerialize = false;
        this.lastOperationDeserialize = false;
    }

    @Override
    protected List<TypeInfo> parseColumnTypes() {
        List<TypeInfo> columnTypes = super.parseColumnTypes();
        return !columnTypes.isEmpty() ? columnTypes : Collections.nCopies(this.getColumnNames().size(), TypeInfoFactory.stringTypeInfo);
    }

    @Override
    public Object doDeserialize(Writable field) throws SerDeException {
        if (this.byteArrayRef == null) {
            this.byteArrayRef = new ByteArrayRef();
        }
        BinaryComparable b = (BinaryComparable)field;
        this.byteArrayRef.setData(b.getBytes());
        this.cachedLazyStruct.init(this.byteArrayRef, 0, b.getLength());
        this.lastOperationSerialize = false;
        this.lastOperationDeserialize = true;
        return this.cachedLazyStruct;
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    @Override
    public Writable doSerialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        List<Object> list = soi.getStructFieldsDataAsList(obj);
        List<? extends StructField> declaredFields = this.serdeParams.getRowTypeInfo() != null && ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames().size() > 0 ? ((StructObjectInspector)this.getObjectInspector()).getAllStructFieldRefs() : null;
        this.serializeStream.reset();
        this.serializedSize = 0L;
        for (int i = 0; i < fields.size(); ++i) {
            Object f;
            if (i > 0) {
                this.serializeStream.write(this.serdeParams.getSeparators()[0]);
            }
            ObjectInspector foi = fields.get(i).getFieldObjectInspector();
            Object object = f = list == null ? null : list.get(i);
            if (declaredFields != null && i >= declaredFields.size()) {
                throw new SerDeException("Error: expecting " + declaredFields.size() + " but asking for field " + i + "\ndata=" + String.valueOf(obj) + "\ntableType=" + this.serdeParams.getRowTypeInfo().toString() + "\ndataType=" + String.valueOf(TypeInfoUtils.getTypeInfoFromObjectInspector(objInspector)));
            }
            this.serializeField(this.serializeStream, f, foi, this.serdeParams);
        }
        this.serializeCache.set(this.serializeStream.getData(), 0, this.serializeStream.getLength());
        this.serializedSize = this.serializeStream.getLength();
        this.lastOperationSerialize = true;
        this.lastOperationDeserialize = false;
        return this.serializeCache;
    }

    protected void serializeField(ByteStream.Output out, Object obj, ObjectInspector objInspector, LazySerDeParameters serdeParams) throws SerDeException {
        try {
            LazySimpleSerDe.serialize(out, obj, objInspector, serdeParams.getSeparators(), 1, serdeParams.getNullSequence(), serdeParams.isEscaped(), serdeParams.getEscapeChar(), serdeParams.getNeedsEscape());
        }
        catch (IOException e) {
            throw new SerDeException(e);
        }
    }

    public static void serialize(ByteStream.Output out, Object obj, ObjectInspector objInspector, byte[] separators, int level, Text nullSequence, boolean escaped, byte escapeChar, boolean[] needsEscape) throws IOException, SerDeException {
        if (obj == null) {
            out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
            return;
        }
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                LazyUtils.writePrimitiveUTF8((OutputStream)((Object)out), obj, (PrimitiveObjectInspector)objInspector, escaped, escapeChar, needsEscape);
                return;
            }
            case LIST: {
                char separator = (char)LazyUtils.getSeparator(separators, level);
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                List<?> list = loi.getList(obj);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            out.write(separator);
                        }
                        LazySimpleSerDe.serialize(out, list.get(i), eoi, separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                    }
                }
                return;
            }
            case MAP: {
                char separator = (char)LazyUtils.getSeparator(separators, level);
                char keyValueSeparator = (char)LazyUtils.getSeparator(separators, level + 1);
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map<?, ?> map = moi.getMap(obj);
                if (map == null) {
                    out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                } else {
                    boolean first = true;
                    for (Map.Entry<?, ?> entry : map.entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            out.write(separator);
                        }
                        LazySimpleSerDe.serialize(out, entry.getKey(), koi, separators, level + 2, nullSequence, escaped, escapeChar, needsEscape);
                        out.write(keyValueSeparator);
                        LazySimpleSerDe.serialize(out, entry.getValue(), voi, separators, level + 2, nullSequence, escaped, escapeChar, needsEscape);
                    }
                }
                return;
            }
            case STRUCT: {
                char separator = (char)LazyUtils.getSeparator(separators, level);
                StructObjectInspector soi = (StructObjectInspector)objInspector;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                List<Object> list = soi.getStructFieldsDataAsList(obj);
                if (list == null) {
                    out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            out.write(separator);
                        }
                        LazySimpleSerDe.serialize(out, list.get(i), fields.get(i).getFieldObjectInspector(), separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                    }
                }
                return;
            }
            case UNION: {
                char separator = (char)LazyUtils.getSeparator(separators, level);
                UnionObjectInspector uoi = (UnionObjectInspector)objInspector;
                List<ObjectInspector> ois = uoi.getObjectInspectors();
                if (ois == null) {
                    out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                } else {
                    LazyUtils.writePrimitiveUTF8((OutputStream)((Object)out), uoi.getTag(obj), PrimitiveObjectInspectorFactory.javaByteObjectInspector, escaped, escapeChar, needsEscape);
                    out.write(separator);
                    LazySimpleSerDe.serialize(out, uoi.getField(obj), ois.get(uoi.getTag(obj)), separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                }
                return;
            }
        }
        throw new RuntimeException("Unknown category type: " + String.valueOf((Object)objInspector.getCategory()));
    }

    @Override
    public SerDeStats getSerDeStats() {
        assert (this.lastOperationSerialize != this.lastOperationDeserialize);
        if (this.lastOperationSerialize) {
            this.stats.setRawDataSize(this.serializedSize);
        } else {
            this.stats.setRawDataSize(this.cachedLazyStruct.getRawDataSerializedSize());
        }
        return this.stats;
    }

    @Override
    protected Writable transformFromUTF8(Writable blob) {
        Text text = (Text)blob;
        return SerDeUtils.transformTextFromUTF8(text, this.charset);
    }

    @Override
    protected Writable transformToUTF8(Writable blob) {
        Text text = (Text)blob;
        return SerDeUtils.transformTextToUTF8(text, this.charset);
    }

    @Deprecated
    public static SerDeParameters initSerdeParams(Configuration job, Properties tbl, String serdeName) throws SerDeException {
        return new SerDeParameters(job, tbl, serdeName);
    }

    @Deprecated
    public static class SerDeParameters
    extends LazySerDeParameters {
        public SerDeParameters(Configuration job, Properties tbl, String serdeName) throws SerDeException {
            super(job, tbl, serdeName);
        }
    }
}

