/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary.objectinspector;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryListObjectInspector;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public final class LazyBinaryObjectInspectorFactory {
    static ConcurrentHashMap<List<Object>, LazyBinaryStructObjectInspector> cachedLazyBinaryStructObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<List<Object>, LazyBinaryUnionObjectInspector> cachedLazyBinaryUnionObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<List<Object>, LazyBinaryListObjectInspector> cachedLazyBinaryListObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<List<Object>, LazyBinaryMapObjectInspector> cachedLazyBinaryMapObjectInspector = new ConcurrentHashMap();

    public static LazyBinaryStructObjectInspector getLazyBinaryStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        return LazyBinaryObjectInspectorFactory.getLazyBinaryStructObjectInspector(structFieldNames, structFieldObjectInspectors, null);
    }

    public static LazyBinaryStructObjectInspector getLazyBinaryStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments) {
        LazyBinaryStructObjectInspector prev;
        List<Object> signature = structFieldComments == null ? Arrays.asList(structFieldNames, structFieldObjectInspectors) : Arrays.asList(structFieldNames, structFieldObjectInspectors, structFieldComments);
        LazyBinaryStructObjectInspector result = cachedLazyBinaryStructObjectInspector.get(signature);
        if (result == null && (prev = cachedLazyBinaryStructObjectInspector.putIfAbsent(signature, result = new LazyBinaryStructObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments))) != null) {
            result = prev;
        }
        return result;
    }

    public static LazyBinaryUnionObjectInspector getLazyBinaryUnionObjectInspector(List<ObjectInspector> unionFieldObjectInspectors) {
        LazyBinaryUnionObjectInspector prev;
        List<List<ObjectInspector>> signature = Collections.singletonList(unionFieldObjectInspectors);
        LazyBinaryUnionObjectInspector result = cachedLazyBinaryUnionObjectInspector.get(signature);
        if (result == null && (prev = cachedLazyBinaryUnionObjectInspector.putIfAbsent(signature, result = new LazyBinaryUnionObjectInspector(unionFieldObjectInspectors))) != null) {
            result = prev;
        }
        return result;
    }

    public static LazyBinaryListObjectInspector getLazyBinaryListObjectInspector(ObjectInspector listElementObjectInspector) {
        LazyBinaryListObjectInspector prev;
        List<ObjectInspector> signature = Collections.singletonList(listElementObjectInspector);
        LazyBinaryListObjectInspector result = cachedLazyBinaryListObjectInspector.get(signature);
        if (result == null && (prev = cachedLazyBinaryListObjectInspector.putIfAbsent(signature, result = new LazyBinaryListObjectInspector(listElementObjectInspector))) != null) {
            result = prev;
        }
        return result;
    }

    public static LazyBinaryMapObjectInspector getLazyBinaryMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector) {
        LazyBinaryMapObjectInspector prev;
        List<Object> signature = Arrays.asList(mapKeyObjectInspector, mapValueObjectInspector);
        LazyBinaryMapObjectInspector result = cachedLazyBinaryMapObjectInspector.get(signature);
        if (result == null && (prev = cachedLazyBinaryMapObjectInspector.putIfAbsent(signature, result = new LazyBinaryMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector))) != null) {
            result = prev;
        }
        return result;
    }

    private LazyBinaryObjectInspectorFactory() {
    }
}

