/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.convert;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.tools.convert.CsvReader;
import org.apache.orc.tools.convert.JsonReader;
import org.apache.orc.tools.json.JsonSchemaFinder;

public class ConvertTool {
    static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy[[-][/]]MM[[-][/]]dd[['T'][ ]]HH:mm:ss[ ][XXX][X]";
    private final List<FileInformation> fileList;
    private final TypeDescription schema;
    private final char csvSeparator;
    private final char csvQuote;
    private final char csvEscape;
    private final int csvHeaderLines;
    private final String csvNullString;
    private final String timestampFormat;
    private final String bloomFilterColumns;
    private final String unionTag;
    private final String unionValue;
    private final Writer writer;
    private final VectorizedRowBatch batch;

    TypeDescription buildSchema(List<FileInformation> files, Configuration conf) throws IOException {
        JsonSchemaFinder schemaFinder = new JsonSchemaFinder();
        int filesScanned = 0;
        for (FileInformation file : files) {
            if (file.format == Format.JSON) {
                System.err.println("Scanning " + String.valueOf(file.path) + " for schema");
                ++filesScanned;
                schemaFinder.addFile(file.getReader((InputStream)file.filesystem.open(file.path)), file.path.getName());
                continue;
            }
            if (file.format != Format.ORC) continue;
            System.err.println("Merging schema from " + String.valueOf(file.path));
            ++filesScanned;
            Reader reader = OrcFile.createReader((Path)file.path, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf).filesystem(file.filesystem));
            reader.close();
            if (files.size() == 1) {
                return reader.getSchema();
            }
            schemaFinder.addSchema(reader.getSchema());
        }
        if (filesScanned == 0) {
            throw new IllegalArgumentException("Please specify a schema using --schema for converting CSV files.");
        }
        return schemaFinder.getSchema();
    }

    public static void main(Configuration conf, String[] args) throws IOException, ParseException {
        new ConvertTool(conf, args).run();
    }

    List<FileInformation> buildFileList(String[] files, Configuration conf) throws IOException {
        ArrayList<FileInformation> result = new ArrayList<FileInformation>(files.length);
        for (String fn : files) {
            result.add(new FileInformation(new Path(fn), conf));
        }
        return result;
    }

    public ConvertTool(Configuration conf, String[] args) throws IOException, ParseException {
        CommandLine opts = ConvertTool.parseOptions(args);
        this.fileList = this.buildFileList(opts.getArgs(), conf);
        this.schema = opts.hasOption('s') ? TypeDescription.fromString((String)opts.getOptionValue('s')) : this.buildSchema(this.fileList, conf);
        this.csvQuote = ConvertTool.getCharOption(opts, 'q', '\"');
        this.csvEscape = ConvertTool.getCharOption(opts, 'e', '\\');
        this.csvSeparator = ConvertTool.getCharOption(opts, 'S', ',');
        this.csvHeaderLines = ConvertTool.getIntOption(opts, 'H', 0);
        this.csvNullString = opts.getOptionValue('n', "");
        this.timestampFormat = opts.getOptionValue("t", DEFAULT_TIMESTAMP_FORMAT);
        this.bloomFilterColumns = opts.getOptionValue('b');
        this.unionTag = opts.getOptionValue("union-tag", "tag");
        this.unionValue = opts.getOptionValue("union-value", "value");
        String outFilename = opts.hasOption('o') ? opts.getOptionValue('o') : "output.orc";
        boolean overwrite = opts.hasOption('O');
        OrcFile.WriterOptions writerOpts = OrcFile.writerOptions((Configuration)conf).setSchema(this.schema).overwrite(overwrite);
        if (this.bloomFilterColumns != null) {
            writerOpts.bloomFilterColumns(this.bloomFilterColumns);
        }
        this.writer = OrcFile.createWriter((Path)new Path(outFilename), (OrcFile.WriterOptions)writerOpts);
        this.batch = this.schema.createRowBatch();
    }

    void run() throws IOException {
        for (FileInformation file : this.fileList) {
            System.err.println("Processing " + String.valueOf(file.path));
            RecordReader reader = file.getRecordReader();
            while (reader.nextBatch(this.batch)) {
                this.writer.addRowBatch(this.batch);
            }
            reader.close();
        }
        this.writer.close();
    }

    private static int getIntOption(CommandLine opts, char letter, int mydefault) {
        if (opts.hasOption(letter)) {
            return Integer.parseInt(opts.getOptionValue(letter));
        }
        return mydefault;
    }

    private static char getCharOption(CommandLine opts, char letter, char mydefault) {
        if (opts.hasOption(letter)) {
            return opts.getOptionValue(letter).charAt(0);
        }
        return mydefault;
    }

    private static CommandLine parseOptions(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt("help").desc("Provide help").build());
        options.addOption(Option.builder((String)"s").longOpt("schema").hasArg().desc("The schema to write in to the file").build());
        options.addOption(Option.builder((String)"b").longOpt("bloomFilterColumns").hasArg().desc("Comma separated values of column names for which bloom filter is to be created").build());
        options.addOption(Option.builder((String)"o").longOpt("output").desc("Output filename").hasArg().build());
        options.addOption(Option.builder((String)"n").longOpt("null").desc("CSV null string").hasArg().build());
        options.addOption(Option.builder((String)"q").longOpt("quote").desc("CSV quote character").hasArg().build());
        options.addOption(Option.builder((String)"e").longOpt("escape").desc("CSV escape character").hasArg().build());
        options.addOption(Option.builder((String)"S").longOpt("separator").desc("CSV separator character").hasArg().build());
        options.addOption(Option.builder((String)"H").longOpt("header").desc("CSV header lines").hasArg().build());
        options.addOption(Option.builder((String)"t").longOpt("timestampformat").desc("Timestamp Format").hasArg().build());
        options.addOption(Option.builder((String)"O").longOpt("overwrite").desc("Overwrite an existing file").build());
        options.addOption(Option.builder().longOpt("union-tag").desc("JSON key name representing UNION tag. Default to \"tag\".").hasArg().build());
        options.addOption(Option.builder().longOpt("union-value").desc("JSON key name representing UNION value. Default to \"value\".").hasArg().build());
        CommandLine cli = new DefaultParser().parse(options, args);
        if (cli.hasOption('h') || cli.getArgs().length == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("convert", options);
            System.exit(1);
        }
        return cli;
    }

    class FileInformation {
        private final Compression compression;
        private final Format format;
        private final Path path;
        private final FileSystem filesystem;
        private final Configuration conf;
        private final long size;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        FileInformation(Path path, Configuration conf) throws IOException {
            this.path = path;
            this.conf = conf;
            this.filesystem = path.getFileSystem(conf);
            this.size = this.filesystem.getFileStatus(path).getLen();
            String name = path.getName();
            int lastDot = name.lastIndexOf(".");
            if (lastDot >= 0 && ".gz".equals(name.substring(lastDot))) {
                this.compression = Compression.GZIP;
                name = name.substring(0, lastDot);
                lastDot = name.lastIndexOf(".");
            } else {
                this.compression = Compression.NONE;
            }
            if (lastDot < 0) throw new IllegalArgumentException("No extension on file " + String.valueOf(path));
            String ext = name.substring(lastDot);
            if (".json".equals(ext) || ".jsn".equals(ext)) {
                this.format = Format.JSON;
                return;
            } else if (".csv".equals(ext)) {
                this.format = Format.CSV;
                return;
            } else {
                if (!".orc".equals(ext)) throw new IllegalArgumentException("Unknown kind of file " + String.valueOf(path));
                this.format = Format.ORC;
            }
        }

        java.io.Reader getReader(InputStream input) throws IOException {
            if (this.compression == Compression.GZIP) {
                input = new GZIPInputStream(input);
            }
            return new InputStreamReader(input, StandardCharsets.UTF_8);
        }

        public RecordReader getRecordReader() throws IOException {
            switch (this.format) {
                case ORC: {
                    Reader reader = OrcFile.createReader((Path)this.path, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
                    return reader.rows(reader.options().schema(ConvertTool.this.schema));
                }
                case JSON: {
                    FSDataInputStream underlying = this.filesystem.open(this.path);
                    return new JsonReader(this.getReader((InputStream)underlying), underlying, this.size, ConvertTool.this.schema, ConvertTool.this.timestampFormat, ConvertTool.this.unionTag, ConvertTool.this.unionValue);
                }
                case CSV: {
                    FSDataInputStream underlying = this.filesystem.open(this.path);
                    return new CsvReader(this.getReader((InputStream)underlying), underlying, this.size, ConvertTool.this.schema, ConvertTool.this.csvSeparator, ConvertTool.this.csvQuote, ConvertTool.this.csvEscape, ConvertTool.this.csvHeaderLines, ConvertTool.this.csvNullString, ConvertTool.this.timestampFormat);
                }
            }
            throw new IllegalArgumentException("Unhandled format " + String.valueOf((Object)this.format) + " for " + String.valueOf(this.path));
        }
    }

    static enum Format {
        JSON,
        CSV,
        ORC;

    }

    static enum Compression {
        NONE,
        GZIP;

    }
}

