/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidMemberMetaDataException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class EmbeddedMetaData
extends MetaData {
    private static final long serialVersionUID = -1180186183944475444L;
    protected String ownerMember;
    protected String nullIndicatorColumn;
    protected String nullIndicatorValue;
    protected DiscriminatorMetaData discriminatorMetaData;
    protected final List<AbstractMemberMetaData> members = new ArrayList<AbstractMemberMetaData>();

    public EmbeddedMetaData(EmbeddedMetaData embmd) {
        super(null, embmd);
        this.ownerMember = embmd.ownerMember;
        this.nullIndicatorColumn = embmd.nullIndicatorColumn;
        this.nullIndicatorValue = embmd.nullIndicatorValue;
        List<AbstractMemberMetaData> embmdMmds = embmd.members;
        for (AbstractMemberMetaData embmdMmd : embmdMmds) {
            if (embmdMmd instanceof FieldMetaData) {
                this.addMember(new FieldMetaData((MetaData)this, embmdMmd));
                continue;
            }
            this.addMember(new PropertyMetaData((MetaData)this, (PropertyMetaData)embmdMmd));
        }
    }

    public EmbeddedMetaData() {
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        int i;
        Class clazz;
        MetaDataManager mmgr = this.getMetaDataManager();
        AbstractMemberMetaData apmd = null;
        AbstractClassMetaData embCmd = null;
        String embeddedType = null;
        MetaData md = this.getParent();
        if (md instanceof AbstractMemberMetaData) {
            apmd = (AbstractMemberMetaData)md;
            embeddedType = apmd.getTypeName();
            embCmd = mmgr.getMetaDataForClassInternal(apmd.getType(), clr);
            if (embCmd == null && apmd.getFieldTypes() != null && apmd.getFieldTypes().length == 1) {
                embCmd = mmgr.getMetaDataForClassInternal(clr.classForName(apmd.getFieldTypes()[0]), clr);
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(Localiser.msg("044121", apmd.getFullFieldName(), apmd.getTypeName()));
                throw new InvalidMemberMetaDataException("044121", apmd.getClassName(), apmd.getName(), apmd.getTypeName());
            }
        } else if (md instanceof ElementMetaData) {
            ElementMetaData elemmd = (ElementMetaData)md;
            apmd = (AbstractMemberMetaData)elemmd.getParent();
            embeddedType = apmd.getCollection().getElementType();
            try {
                Class clazz2 = clr.classForName(embeddedType, primary);
                embCmd = mmgr.getMetaDataForClassInternal(clazz2, clr);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(Localiser.msg("044122", apmd.getFullFieldName(), embeddedType));
                throw new InvalidMemberMetaDataException("044122", apmd.getClassName(), apmd.getName(), embeddedType);
            }
        } else if (md instanceof KeyMetaData) {
            KeyMetaData keymd = (KeyMetaData)md;
            apmd = (AbstractMemberMetaData)keymd.getParent();
            embeddedType = apmd.getMap().getKeyType();
            try {
                Class clazz3 = clr.classForName(embeddedType, primary);
                embCmd = mmgr.getMetaDataForClassInternal(clazz3, clr);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(Localiser.msg("044123", apmd.getFullFieldName(), embeddedType));
                throw new InvalidMemberMetaDataException("044123", apmd.getClassName(), apmd.getName(), embeddedType);
            }
        } else if (md instanceof ValueMetaData) {
            ValueMetaData valuemd = (ValueMetaData)md;
            apmd = (AbstractMemberMetaData)valuemd.getParent();
            embeddedType = apmd.getMap().getValueType();
            try {
                Class clazz4 = clr.classForName(embeddedType, primary);
                embCmd = mmgr.getMetaDataForClassInternal(clazz4, clr);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(Localiser.msg("044124", apmd.getFullFieldName(), embeddedType));
                throw new InvalidMemberMetaDataException("044124", apmd.getClassName(), apmd.getName(), embeddedType);
            }
        } else {
            throw new InvalidMemberMetaDataException("044165", new Object[]{md.getClass().getName()});
        }
        for (AbstractMemberMetaData abstractMemberMetaData : this.members) {
            if (!(embCmd instanceof InterfaceMetaData) || !(abstractMemberMetaData instanceof FieldMetaData)) continue;
            throw new InvalidMemberMetaDataException("044129", apmd.getClassName(), apmd.getName(), abstractMemberMetaData.getName());
        }
        HashSet<String> memberNames = new HashSet<String>();
        for (AbstractMemberMetaData mmd : this.members) {
            memberNames.add(mmd.getName());
        }
        Object var9_22 = null;
        Collections.sort(this.members);
        try {
            clazz = clr.classForName(embeddedType, primary);
            Field[] cls_fields = clazz.getDeclaredFields();
            for (i = 0; i < cls_fields.length; ++i) {
                if (!cls_fields[i].getDeclaringClass().getName().equals(embeddedType) || mmgr.isEnhancerField(cls_fields[i].getName()) || ClassUtils.isInnerClass(cls_fields[i].getName()) || Modifier.isStatic(cls_fields[i].getModifiers()) || memberNames.contains(cls_fields[i].getName())) continue;
                AbstractMemberMetaData embMmd = embCmd.getMetaDataForMember(cls_fields[i].getName());
                FieldMetaData omittedFmd = null;
                if (embMmd != null) {
                    FieldPersistenceModifier fieldModifier = embMmd.getPersistenceModifier();
                    if (fieldModifier == FieldPersistenceModifier.DEFAULT) {
                        fieldModifier = embMmd.getDefaultFieldPersistenceModifier(cls_fields[i].getType(), cls_fields[i].getModifiers(), mmgr.isFieldTypePersistable(cls_fields[i].getType()), mmgr);
                    }
                    if (fieldModifier == FieldPersistenceModifier.PERSISTENT) {
                        omittedFmd = new FieldMetaData((MetaData)this, embMmd);
                        omittedFmd.setPrimaryKey(false);
                    }
                } else {
                    omittedFmd = new FieldMetaData((MetaData)this, cls_fields[i].getName());
                }
                if (omittedFmd == null) continue;
                NucleusLogger.METADATA.debug(Localiser.msg("044125", apmd.getClassName(), cls_fields[i].getName(), embeddedType));
                this.members.add(omittedFmd);
                memberNames.add(omittedFmd.getName());
                Collections.sort(this.members);
            }
        }
        catch (Exception e) {
            NucleusLogger.METADATA.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
        if (embCmd instanceof InterfaceMetaData) {
            try {
                Method[] clsMethods = clazz.getDeclaredMethods();
                for (i = 0; i < clsMethods.length; ++i) {
                    String fieldName;
                    if (!clsMethods[i].getDeclaringClass().getName().equals(embeddedType) || !clsMethods[i].getName().startsWith("get") && !clsMethods[i].getName().startsWith("is") || clsMethods[i].isBridge() || ClassUtils.isInnerClass(clsMethods[i].getName()) || memberNames.contains(fieldName = ClassUtils.getFieldNameForJavaBeanGetter(clsMethods[i].getName()))) continue;
                    NucleusLogger.METADATA.debug(Localiser.msg("044060", apmd.getClassName(), fieldName));
                    PropertyMetaData pmd = new PropertyMetaData((MetaData)this, fieldName);
                    this.members.add(pmd);
                    memberNames.add(pmd.getName());
                    Collections.sort(this.members);
                }
            }
            catch (Exception e) {
                NucleusLogger.METADATA.error(e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        }
        Collections.sort(this.members);
        for (AbstractMemberMetaData mmd : this.members) {
            Class embMmdClass = clazz;
            if (!mmd.fieldBelongsToClass()) {
                try {
                    embMmdClass = clr.classForName(mmd.getClassName(true));
                }
                catch (ClassNotResolvedException cnre) {
                    String fieldClsName = clazz.getPackage().getName() + "." + mmd.getClassName(true);
                    mmd.setClassName(fieldClsName);
                    embMmdClass = clr.classForName(fieldClsName);
                }
            }
            if (mmd instanceof FieldMetaData) {
                Field cls_field = null;
                try {
                    cls_field = embMmdClass.getDeclaredField(mmd.getName());
                }
                catch (Exception e) {
                    throw new InvalidMemberMetaDataException("044071", embMmdClass.getName(), mmd.getName());
                }
                mmd.populate(clr, cls_field, null, primary, mmgr);
                continue;
            }
            Method clsMethod = null;
            try {
                clsMethod = embMmdClass.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(mmd.getName(), true), new Class[0]);
            }
            catch (Exception e) {
                try {
                    clsMethod = embMmdClass.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(mmd.getName(), false), new Class[0]);
                }
                catch (Exception e2) {
                    throw new InvalidMemberMetaDataException("044071", embMmdClass.getName(), mmd.getName());
                }
            }
            mmd.populate(clr, null, clsMethod, primary, mmgr);
        }
        if (embCmd.isEmbeddedOnly()) {
            for (AbstractMemberMetaData mmd : this.members) {
                if (mmd.getTypeName().equals(embCmd.getFullClassName())) {
                    throw new InvalidMetaDataException("044128", embCmd.getFullClassName(), mmd.getName());
                }
                if (!mmd.hasCollection() || !mmd.getCollection().getElementType().equals(embCmd.getFullClassName())) continue;
                throw new InvalidMetaDataException("044128", embCmd.getFullClassName(), mmd.getName());
            }
        }
    }

    @Override
    public void initialise(ClassLoaderResolver clr) {
        for (AbstractMemberMetaData mmd : this.members) {
            mmd.initialise(clr);
        }
        if (this.discriminatorMetaData != null) {
            this.discriminatorMetaData.initialise(clr);
        }
        this.setInitialised();
    }

    public final List<AbstractMemberMetaData> getMemberMetaData() {
        return this.members;
    }

    public final String getOwnerMember() {
        return this.ownerMember;
    }

    public EmbeddedMetaData setOwnerMember(String ownerMember) {
        this.ownerMember = StringUtils.isWhitespace(ownerMember) ? null : ownerMember;
        return this;
    }

    public final String getNullIndicatorColumn() {
        return this.nullIndicatorColumn;
    }

    public EmbeddedMetaData setNullIndicatorColumn(String column) {
        this.nullIndicatorColumn = StringUtils.isWhitespace(column) ? null : column;
        return this;
    }

    public final String getNullIndicatorValue() {
        return this.nullIndicatorValue;
    }

    public EmbeddedMetaData setNullIndicatorValue(String value) {
        this.nullIndicatorValue = StringUtils.isWhitespace(value) ? null : value;
        return this;
    }

    public final DiscriminatorMetaData getDiscriminatorMetaData() {
        return this.discriminatorMetaData;
    }

    public EmbeddedMetaData setDiscriminatorMetaData(DiscriminatorMetaData dismd) {
        this.discriminatorMetaData = dismd;
        this.discriminatorMetaData.parent = this;
        return this;
    }

    public DiscriminatorMetaData newDiscriminatorMetaData() {
        DiscriminatorMetaData dismd = new DiscriminatorMetaData();
        this.setDiscriminatorMetaData(dismd);
        return dismd;
    }

    public void addMember(AbstractMemberMetaData mmd) {
        if (mmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new InvalidMemberMetaDataException("044108", mmd.getClassName(), mmd.getName());
        }
        for (AbstractMemberMetaData md : this.members) {
            if (!mmd.getName().equals(md.getName())) continue;
            throw new InvalidMemberMetaDataException("044112", mmd.getClassName(), mmd.getName());
        }
        this.members.add(mmd);
        mmd.parent = this;
    }

    public FieldMetaData newFieldMetaData(String name) {
        FieldMetaData fmd = new FieldMetaData((MetaData)this, name);
        this.addMember(fmd);
        return fmd;
    }

    public PropertyMetaData newPropertyMetaData(String name) {
        PropertyMetaData pmd = new PropertyMetaData((MetaData)this, name);
        this.addMember(pmd);
        return pmd;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(super.toString());
        str.append(" [" + this.members.size() + " members] (");
        Iterator<AbstractMemberMetaData> memberIter = this.members.iterator();
        while (memberIter.hasNext()) {
            AbstractMemberMetaData mmd = memberIter.next();
            str.append(mmd.getName());
            if (!memberIter.hasNext()) continue;
            str.append(",");
        }
        str.append(")");
        return str.toString();
    }
}

