/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import org.datanucleus.FetchPlan;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class LifeCycleState {
    public static final int TRANSIENT = 0;
    public static final int P_NEW = 1;
    public static final int P_CLEAN = 2;
    public static final int P_DIRTY = 3;
    public static final int HOLLOW = 4;
    public static final int T_CLEAN = 5;
    public static final int T_DIRTY = 6;
    public static final int P_NEW_DELETED = 7;
    public static final int P_DELETED = 8;
    public static final int P_NONTRANS = 9;
    public static final int P_NONTRANS_DIRTY = 10;
    public static final int DETACHED_CLEAN = 11;
    public static final int DETACHED_DIRTY = 12;
    public static final int TOTAL = 13;
    public static final int ILLEGAL_STATE = 13;
    protected boolean isDirty;
    protected boolean isNew;
    protected boolean isDeleted;
    protected boolean isTransactional;
    protected boolean isPersistent;
    protected int stateType;

    public final int stateType() {
        return this.stateType;
    }

    protected final LifeCycleState changeState(DNStateManager sm, int newStateType) {
        LifeCycleState newState = sm.getExecutionContext().getNucleusContext().getApiAdapter().getLifeCycleState(newStateType);
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("027016", IdentityUtils.getPersistableIdentityForId(sm.getInternalObjectId()), this, newState));
        }
        if (this.isTransactional) {
            if (newState == null || !newState.isTransactional) {
                sm.evictFromTransaction();
            }
        } else if (newState != null && newState.isTransactional) {
            sm.enlistInTransaction();
        }
        if (newState == null) {
            sm.disconnect();
        }
        return newState;
    }

    protected final LifeCycleState changeTransientState(DNStateManager sm, int newStateType) {
        LifeCycleState newState = sm.getExecutionContext().getNucleusContext().getApiAdapter().getLifeCycleState(newStateType);
        try {
            sm.enlistInTransaction();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newState;
    }

    public LifeCycleState transitionMakePersistent(DNStateManager sm) {
        return this;
    }

    public LifeCycleState transitionDeletePersistent(DNStateManager sm) {
        return this;
    }

    public LifeCycleState transitionMakeTransactional(DNStateManager sm, boolean refreshFields) {
        return this;
    }

    public LifeCycleState transitionMakeNontransactional(DNStateManager sm) {
        return this;
    }

    public LifeCycleState transitionMakeTransient(DNStateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        return this;
    }

    public LifeCycleState transitionBegin(DNStateManager sm, Transaction tx) {
        return this;
    }

    public LifeCycleState transitionCommit(DNStateManager sm, Transaction tx) {
        return this;
    }

    public LifeCycleState transitionRollback(DNStateManager sm, Transaction tx) {
        return this;
    }

    public LifeCycleState transitionRefresh(DNStateManager sm) {
        return this;
    }

    public LifeCycleState transitionEvict(DNStateManager sm) {
        return this;
    }

    public LifeCycleState transitionReadField(DNStateManager sm, boolean isLoaded) {
        return this;
    }

    public LifeCycleState transitionWriteField(DNStateManager sm) {
        return this;
    }

    public LifeCycleState transitionRetrieve(DNStateManager sm, boolean fgOnly) {
        return this;
    }

    public LifeCycleState transitionRetrieve(DNStateManager sm, FetchPlan fetchPlan) {
        return this;
    }

    public LifeCycleState transitionDetach(DNStateManager sm) {
        return this;
    }

    public LifeCycleState transitionAttach(DNStateManager sm) {
        return this;
    }

    public LifeCycleState transitionSerialize(DNStateManager sm) {
        return this;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final boolean isNew() {
        return this.isNew;
    }

    public final boolean isDeleted() {
        return this.isDeleted;
    }

    public final boolean isTransactional() {
        return this.isTransactional;
    }

    public final boolean isPersistent() {
        return this.isPersistent;
    }

    public abstract String toString();
}

