/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class AttachFieldManager
extends AbstractFieldManager {
    private final DNStateManager attachedSM;
    private final boolean[] secondClassMutableFields;
    private final boolean[] dirtyFields;
    private final boolean persistent;
    private final boolean cascadeAttach;
    boolean copy = true;

    public AttachFieldManager(DNStateManager attachedSM, boolean[] secondClassMutableFields, boolean[] dirtyFields, boolean persistent, boolean cascadeAttach, boolean copy) {
        this.attachedSM = attachedSM;
        this.secondClassMutableFields = secondClassMutableFields;
        this.dirtyFields = dirtyFields;
        this.persistent = persistent;
        this.cascadeAttach = cascadeAttach;
        this.copy = copy;
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractClassMetaData cmd = this.attachedSM.getClassMetaData();
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        ExecutionContext ec = this.attachedSM.getExecutionContext();
        RelationType relationType = mmd.getRelationType(ec.getClassLoaderResolver());
        if (mmd.hasExtension("attach") && mmd.getValueForExtension("attach").toLowerCase().equals("never")) {
            this.attachedSM.replaceFieldMakeDirty(fieldNumber, null);
            return;
        }
        if (RelationType.isRelationSingleValued(relationType) && !mmd.isCascadeAttach()) {
            NucleusLogger.GENERAL.debug(">> AttachFM.storeObjectField mmd=" + mmd.getFullFieldName() + " but not allowed to merge it, so unloading field");
            this.attachedSM.unloadField(mmd.getAbsoluteFieldNumber());
            return;
        }
        if (RelationType.isRelationMultiValued(relationType) && !mmd.isCascadeAttach()) {
            NucleusLogger.GENERAL.debug(">> AttachFM.storeObjectField mmd=" + mmd.getFullFieldName() + " but not allowed to merge it, so unloading field");
            this.attachedSM.unloadField(mmd.getAbsoluteFieldNumber());
            return;
        }
        ApiAdapter api = ec.getApiAdapter();
        if (value == null) {
            Object oldValue = null;
            if (mmd.isDependent() && this.persistent) {
                try {
                    this.attachedSM.loadFieldFromDatastore(fieldNumber);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                oldValue = this.attachedSM.provideField(fieldNumber);
            }
            this.attachedSM.replaceField(fieldNumber, null);
            if (this.dirtyFields[fieldNumber] || !this.persistent) {
                this.attachedSM.makeDirty(fieldNumber);
            }
            if (mmd.isDependent() && !mmd.isEmbedded() && oldValue != null && api.isPersistable(oldValue)) {
                this.attachedSM.flush();
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("026026", oldValue, mmd.getFullFieldName()));
                ec.deleteObjectInternal(oldValue);
            }
        } else if (this.secondClassMutableFields[fieldNumber]) {
            if (mmd.isSerialized() && !RelationType.isRelationMultiValued(relationType)) {
                this.attachedSM.replaceFieldMakeDirty(fieldNumber, value);
                this.attachedSM.makeDirty(fieldNumber);
            } else {
                SCO<Object> sco;
                Object oldValue = null;
                if (this.persistent && !this.attachedSM.isFieldLoaded(fieldNumber)) {
                    this.attachedSM.loadField(fieldNumber);
                }
                oldValue = this.attachedSM.provideField(fieldNumber);
                boolean changed = this.dirtyFields[fieldNumber];
                if (!changed) {
                    if (oldValue == null) {
                        changed = true;
                    } else if (mmd.hasCollection() && relationType != RelationType.NONE) {
                        boolean collsEqual = SCOUtils.collectionsAreEqual(api, (Collection)oldValue, (Collection)value);
                        changed = !collsEqual;
                    } else {
                        boolean bl = changed = !oldValue.equals(value);
                    }
                }
                if (oldValue == null || !(oldValue instanceof SCO)) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(Localiser.msg("026029", IdentityUtils.getPersistableIdentityForId(this.attachedSM.getInternalObjectId()), mmd.getName()));
                    }
                    if ((sco = SCOUtils.wrapSCOField(this.attachedSM, mmd, value.getClass(), null, false)) instanceof SCOContainer) {
                        ((SCOContainer)sco).load();
                    }
                    this.attachedSM.replaceFieldMakeDirty(fieldNumber, sco);
                } else {
                    sco = (SCO<Object>)oldValue;
                }
                if (this.cascadeAttach) {
                    if (this.copy) {
                        sco.attachCopy(value);
                    } else if (sco instanceof Collection) {
                        SCOUtils.attachForCollection(this.attachedSM, ((Collection)value).toArray(), SCOUtils.collectionHasElementsWithoutIdentity(mmd));
                    } else if (sco instanceof Map) {
                        SCOUtils.attachForMap(this.attachedSM, ((Map)value).entrySet(), SCOUtils.mapHasKeysWithoutIdentity(mmd), SCOUtils.mapHasValuesWithoutIdentity(mmd));
                    } else {
                        sco.initialise(value);
                    }
                }
                if (changed || !this.persistent) {
                    this.attachedSM.makeDirty(fieldNumber);
                }
            }
        } else if (mmd.getType().isArray() && RelationType.isRelationMultiValued(relationType)) {
            if (mmd.isSerialized() || mmd.isEmbedded()) {
                this.attachedSM.replaceField(fieldNumber, value);
                if (this.dirtyFields[fieldNumber] || !this.persistent) {
                    this.attachedSM.makeDirty(fieldNumber);
                }
            } else {
                Object oldValue = this.attachedSM.provideField(fieldNumber);
                if (oldValue == null && !this.attachedSM.getLoadedFields()[fieldNumber] && this.persistent) {
                    this.attachedSM.loadField(fieldNumber);
                    oldValue = this.attachedSM.provideField(fieldNumber);
                }
                if (this.cascadeAttach) {
                    Object arr = Array.newInstance(mmd.getType().getComponentType(), Array.getLength(value));
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object elem = Array.get(value, i);
                        if (this.copy) {
                            Object elemAttached = ec.attachObjectCopy(this.attachedSM, elem, false);
                            Array.set(arr, i, elemAttached);
                            continue;
                        }
                        ec.attachObject(this.attachedSM, elem, false);
                        Array.set(arr, i, elem);
                    }
                    this.attachedSM.replaceFieldMakeDirty(fieldNumber, arr);
                }
                if (this.dirtyFields[fieldNumber] || !this.persistent) {
                    this.attachedSM.makeDirty(fieldNumber);
                }
            }
        } else if (RelationType.isRelationSingleValued(relationType)) {
            DNStateManager valueSM = ec.findStateManager(value);
            if (valueSM != null && valueSM.getReferencedPC() != null && !api.isPersistent(value)) {
                if (this.dirtyFields[fieldNumber]) {
                    this.attachedSM.replaceFieldMakeDirty(fieldNumber, valueSM.getReferencedPC());
                } else {
                    this.attachedSM.replaceField(fieldNumber, valueSM.getReferencedPC());
                }
            }
            if (this.cascadeAttach) {
                boolean sco;
                boolean bl = sco = mmd.getEmbeddedMetaData() != null || mmd.isSerialized() || mmd.isEmbedded();
                if (this.copy) {
                    value = ec.attachObjectCopy(this.attachedSM, value, sco);
                    if (sco || this.dirtyFields[fieldNumber]) {
                        this.attachedSM.replaceFieldMakeDirty(fieldNumber, value);
                    } else {
                        this.attachedSM.replaceField(fieldNumber, value);
                    }
                } else {
                    ec.attachObject(this.attachedSM, value, sco);
                }
                if (this.dirtyFields[fieldNumber] || !this.persistent) {
                    this.attachedSM.makeDirty(fieldNumber);
                } else if (sco && value != null && api.isDirty(value)) {
                    this.attachedSM.makeDirty(fieldNumber);
                }
            } else if (this.dirtyFields[fieldNumber] || !this.persistent) {
                this.attachedSM.makeDirty(fieldNumber);
            }
        } else {
            this.attachedSM.replaceField(fieldNumber, value);
            if (this.dirtyFields[fieldNumber] || !this.persistent) {
                this.attachedSM.makeDirty(fieldNumber);
            }
        }
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeBooleanField(fieldNumber, value);
        this.attachedSM.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.attachedSM.makeDirty(fieldNumber);
        }
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeByteField(fieldNumber, value);
        this.attachedSM.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.attachedSM.makeDirty(fieldNumber);
        }
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeCharField(fieldNumber, value);
        this.attachedSM.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.attachedSM.makeDirty(fieldNumber);
        }
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeDoubleField(fieldNumber, value);
        this.attachedSM.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.attachedSM.makeDirty(fieldNumber);
        }
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeFloatField(fieldNumber, value);
        this.attachedSM.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.attachedSM.makeDirty(fieldNumber);
        }
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeIntField(fieldNumber, value);
        this.attachedSM.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.attachedSM.makeDirty(fieldNumber);
        }
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeLongField(fieldNumber, value);
        this.attachedSM.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.attachedSM.makeDirty(fieldNumber);
        }
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeShortField(fieldNumber, value);
        this.attachedSM.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.attachedSM.makeDirty(fieldNumber);
        }
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeStringField(fieldNumber, value);
        this.attachedSM.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.attachedSM.makeDirty(fieldNumber);
        }
    }
}

