/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.inmemory.method;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.store.query.inmemory.InvocationEvaluator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class StringMatchesMethod
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        if (invokedValue == null) {
            return Boolean.FALSE;
        }
        if (!(invokedValue instanceof String)) {
            throw new NucleusException(Localiser.msg("021011", method, invokedValue.getClass().getName()));
        }
        String arg = null;
        Object argObj = null;
        Expression param = expr.getArguments().get(0);
        if (expr.getArguments().size() > 1) {
            NucleusLogger.QUERY.info("Please note that any escape character is currently ignored");
        }
        if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            argObj = eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            argObj = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (param instanceof Literal) {
            argObj = ((Literal)param).getLiteral();
        } else if (param instanceof InvokeExpression) {
            argObj = eval.getValueForInvokeExpression((InvokeExpression)param);
        } else {
            throw new NucleusException(method + "(param) where param is instanceof " + param.getClass().getName() + " not supported");
        }
        arg = QueryUtils.getStringValue(argObj);
        if (eval.getQueryLanguage().equals(QueryLanguage.JPQL.name())) {
            String matchesArg = arg;
            matchesArg = StringUtils.replaceAll(matchesArg, "%", ".*");
            arg = matchesArg = matchesArg.replace('_', '.');
        }
        return ((String)invokedValue).matches(arg) ? Boolean.TRUE : Boolean.FALSE;
    }
}

