/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractGenerator<T>
implements ValueGenerator<T> {
    protected StoreManager storeMgr;
    protected String name;
    protected int allocationSize = 5;
    protected int initialValue = 0;
    protected ValueGenerationBlock<T> block;

    public AbstractGenerator(StoreManager storeMgr, String name) {
        this.storeMgr = storeMgr;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public synchronized T next() {
        if (this.block == null || !this.block.hasNext()) {
            this.block = this.obtainGenerationBlock();
        }
        return this.block.next();
    }

    @Override
    public synchronized T current() {
        if (this.block == null) {
            return null;
        }
        return this.block.current();
    }

    @Override
    public long nextValue() {
        return this.getLongValueForObject(this.next());
    }

    @Override
    public long currentValue() {
        return this.getLongValueForObject(this.current());
    }

    private long getLongValueForObject(Object oid) {
        if (oid instanceof Long) {
            return (Long)oid;
        }
        if (oid instanceof Integer) {
            return ((Integer)oid).longValue();
        }
        if (oid instanceof Short) {
            return ((Short)oid).longValue();
        }
        throw new NucleusDataStoreException(Localiser.msg("040009", this.name));
    }

    @Override
    public synchronized void allocate(int additional) {
        if (this.block == null) {
            this.block = this.obtainGenerationBlock(additional);
        } else {
            this.block.addBlock(this.obtainGenerationBlock(additional));
        }
    }

    protected ValueGenerationBlock<T> obtainGenerationBlock() {
        return this.obtainGenerationBlock(-1);
    }

    protected ValueGenerationBlock<T> obtainGenerationBlock(int number) {
        ValueGenerationBlock<T> block = null;
        try {
            block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
        }
        catch (ValueGenerationException vex) {
            NucleusLogger.VALUEGENERATION.info(Localiser.msg("040003", vex.getMessage()));
            throw vex;
        }
        catch (RuntimeException ex) {
            NucleusLogger.VALUEGENERATION.info(Localiser.msg("040003", ex.getMessage()));
            throw ex;
        }
        return block;
    }

    protected ValueGenerationBlock<T> reserveBlock() {
        return this.reserveBlock(this.allocationSize);
    }

    protected abstract ValueGenerationBlock<T> reserveBlock(long var1);
}

