/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import java.util.function.Function;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.BaseDVFileWriter;
import org.apache.iceberg.deletes.DVFileWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class PartitioningDVWriter<T>
implements PartitioningWriter<PositionDelete<T>, DeleteWriteResult> {
    private final DVFileWriter writer;
    private DeleteWriteResult result;

    public PartitioningDVWriter(OutputFileFactory fileFactory, Function<CharSequence, PositionDeleteIndex> loadPreviousDeletes) {
        this.writer = new BaseDVFileWriter(fileFactory, loadPreviousDeletes::apply);
    }

    @Override
    public void write(PositionDelete<T> row, PartitionSpec spec, StructLike partition) {
        this.writer.delete(row.path().toString(), row.pos(), spec, partition);
    }

    @Override
    public DeleteWriteResult result() {
        Preconditions.checkState(this.result != null, "Cannot get result from unclosed writer");
        return this.result;
    }

    @Override
    public void close() throws IOException {
        if (this.result == null) {
            this.writer.close();
            this.result = this.writer.result();
        }
    }
}

