/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.mr.hive.FilesForCommit;
import org.apache.iceberg.mr.hive.IcebergAcidUtil;
import org.apache.iceberg.mr.hive.writer.HiveFileWriterFactory;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriterBase;
import org.apache.iceberg.mr.hive.writer.WriterBuilder;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.DeleteFileSet;

class HiveIcebergDeleteWriter
extends HiveIcebergWriterBase {
    private final GenericRecord rowDataTemplate;
    private final boolean skipRowData;
    private final boolean isMergeTask;

    HiveIcebergDeleteWriter(Table table, Map<String, DeleteFileSet> rewritableDeletes, HiveFileWriterFactory writerFactory, OutputFileFactory deleteFileFactory, WriterBuilder.Context context) {
        super(table, HiveIcebergDeleteWriter.newDeleteWriter(table, rewritableDeletes, writerFactory, deleteFileFactory, context));
        this.rowDataTemplate = GenericRecord.create(table.schema());
        this.skipRowData = context.skipRowData();
        this.isMergeTask = context.isMergeTask();
    }

    public void write(Writable row) throws IOException {
        PartitionKey partitionKey;
        Record rec = (Record)((Container)row).get();
        PositionDelete<Record> positionDelete = IcebergAcidUtil.getPositionDelete(rec, this.rowDataTemplate);
        int specId = IcebergAcidUtil.parseSpecId(rec);
        PartitionKey partitionKey2 = partitionKey = this.isMergeTask ? IcebergAcidUtil.parsePartitionKey(rec) : this.partition(positionDelete.row(), specId);
        if (this.skipRowData) {
            positionDelete.set(positionDelete.path(), positionDelete.pos(), null);
        }
        this.writer.write(positionDelete, (PartitionSpec)this.specs.get(specId), partitionKey);
    }

    @Override
    public FilesForCommit files() {
        DeleteWriteResult result = (DeleteWriteResult)this.writer.result();
        List<DeleteFile> deleteFiles = result.deleteFiles();
        CharSequenceSet referencedDataFiles = result.referencedDataFiles();
        List<DeleteFile> rewrittenDeleteFiles = result.rewrittenDeleteFiles();
        return FilesForCommit.onlyDelete(deleteFiles, referencedDataFiles, rewrittenDeleteFiles);
    }
}

