/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;
import org.apache.iceberg.util.SerializationUtil;

public class IcebergSplit
extends InputSplit
implements IcebergSplitContainer {
    public static final String[] ANYWHERE = new String[]{"*"};
    private ScanTaskGroup<FileScanTask> taskGroup;
    private transient String[] locations;
    private transient Configuration conf;

    public IcebergSplit() {
    }

    IcebergSplit(Configuration conf, ScanTaskGroup<FileScanTask> taskGroup) {
        this.taskGroup = taskGroup;
        this.conf = conf;
    }

    public ScanTaskGroup<FileScanTask> taskGroup() {
        return this.taskGroup;
    }

    @Override
    public IcebergSplit icebergSplit() {
        return this;
    }

    public long getLength() {
        return this.taskGroup.tasks().stream().mapToLong(ContentScanTask::length).sum();
    }

    public String[] getLocations() {
        boolean localityPreferred;
        this.locations = this.locations == null && this.conf != null ? ((localityPreferred = this.conf.getBoolean("iceberg.mr.locality", false)) ? Util.blockLocations(this.taskGroup, this.conf) : ANYWHERE) : ANYWHERE;
        return this.locations;
    }

    public void write(DataOutput out) throws IOException {
        byte[] data = SerializationUtil.serializeToBytes(this.taskGroup);
        out.writeInt(data.length);
        out.write(data);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        this.taskGroup = (ScanTaskGroup)SerializationUtil.deserializeFromBytes(data);
    }
}

